#ifndef __SCREEN_H__
#define __SCREEN_H__

class Screen {
public:
    Screen(void);
    void clear(void);
    void putchar(int c);
    void printf(const char* format, ...);

private:
    enum {
        VIDEO     = 0xB8000,
        COLUMNS   = 80,
        LINES     = 24,
        ATTRIBUTE = 7,
    };
    volatile uint8* vram;
    uint32 xpos, ypos;

    void scroll(void);
};

extern Screen Console;

#endif /* __SCREEN_H__ */
