#ifndef __TIMER_H__
#define __TIMER_H__

#include "queue.h"

class Timer;

class TimerJob : public Object
{
    friend class Timer;

public:
    TimerJob(uint32 dur) : Start(0), Timeout(0), Duration(dur) {}
    virtual void onExpire(void) {};

private:
    uint32 Start;
    uint32 Timeout;
    uint32 Duration;
};

class Timer
{
public:
    static const uint32 MAX_COUNT = 0x7FFFFFFF;

    Timer(void);
    void init(void);
    void add(TimerJob& job);
    void abort(TimerJob& job);
    Timer& operator++(void);

private:
    uint32        Count;
    PriorityQueue JobQueue;

    class TimerJobComparator : public Comparator {
        int compare(Object& src1, Object& src2) {
            TimerJob& job1 = (TimerJob&)src1;
            TimerJob& job2 = (TimerJob&)src2;
            return int(job1.Timeout - job2.Timeout);
        }
    } JobCmp;

    void checkExpire(TimerJob& job);
};

extern Timer SystemTimer;

#endif /*__TIMER_H__ */
