#ifndef __DMAC_H__
#define __DMAC_H__

#include <device.h>
#include <ioport.h>

class DmaController : public Device
{
public:
    static DmaController* getInstance(void) {
        if (Instance == 0) Instance = new DmaController();
        return Instance;
    }

    class Channel {
    public:
        Channel(uint8 num, 
                IoPortLib::IoPort adr,
                IoPortLib::IoPort cnt,
                IoPortLib::IoPort pgadr) : 
            Num(num), AdrReg(adr), CntReg(cnt), PageReg(pgadr) {}
        void start(void) {IoPortLib::out8(IoPortLib::DMAC0_SMASK, Num);}
        void stop(void)  {IoPortLib::out8(IoPortLib::DMAC0_SMASK, Num | 4);}
        void startReadXfer(size_t size);
        void startWriteXfer(size_t size);

    private:
        uint8 Num; // channel number
        IoPortLib::IoPort AdrReg;
        IoPortLib::IoPort CntReg;
        IoPortLib::IoPort PageReg;
        uint8* Buffer;
    };

private:
    static DmaController* Instance;
    Channel* Ch[4];

    DmaController(void);
    DmaController(const DmaController& src) {}
};

#endif /* __DMAC_H__ */
