#ifndef __GDT_H__
#define __GDT_H__

#include <types.h>
#include <descripter.h>

struct GdtEntry 
{
    enum {
        G_FLAG   = 0x0800,
        D_FLAG   = 0x0400,
        AVL_FLAG = 0x0100,
        P_FLAG   = 0x0080,
        DPL0     = 0x0000,
        DPL1     = 0x0020,
        DPL2     = 0x0040,
        DPL3     = 0x0060,
        S_FLAG   = 0x0010,
        TYPE_CS  = 0x000A,
        TYPE_DS  = 0x0002,
        TYPE_SS  = 0x0006,
        A_FLAG   = 0x0001
    };
    uint16 LimitLow;
    uint16 SegBaseLow;
    uint8  SegBaseMid;
    uint8  TypeLow;
    uint8  TypeHi  :4;
    uint8  LimitHi :4;
    uint8  SegBaseHi;
} __attribute__ ((packed));

class Gdt 
{
public:
    static const int NUM = 8192;

    enum {
        NULL_S    = 0,
        KERNEL_CS = 1,
        KERNEL_DS = 2
    };

    static const uint16 KERNEL_CS_FLAG = 
        (GdtEntry::G_FLAG | GdtEntry::D_FLAG | GdtEntry::P_FLAG | 
         GdtEntry::DPL0   | GdtEntry::S_FLAG | GdtEntry::TYPE_CS); 
    static const uint16 KERNEL_DS_FLAG = 
        (GdtEntry::G_FLAG | GdtEntry::D_FLAG | GdtEntry::P_FLAG | 
         GdtEntry::DPL0   | GdtEntry::S_FLAG | GdtEntry::TYPE_DS); 

    static Gdt* getInstance(void);

    void set(int index, uint32 segbase, uint32 limit, uint16 type);
    void load(void) const;

private:
    Gdt(void);
    Gdt(const Gdt& src) {}
    void init(void);

    DescripterTable Table      __attribute__((aligned(8)));
    GdtEntry        Entry[NUM] __attribute__((aligned(8)));
    
    static Gdt* Instance;
};

#endif /* __GDT_H__ */
