#ifndef __IDT_H__
#define __IDT_H__

#include <types.h>
#include <descripter.h>

struct IdtEntry 
{
    uint16 OffsetLow;
    uint16 Selector;
    uint16 Copy :8;
    uint16 Type :8;
    uint16 OffsetHi;
} __attribute__ ((packed));

class Idt 
{
public:
    static const int NUM = 256;

    static Idt* getInstance(void);

    void set(int index, uint32 offset, uint16 selector, uint8 copy, uint8 type);
    void load(void) const;

private:
    Idt(void);
    Idt(const Idt& src) {}

    DescripterTable Table      __attribute__((aligned(8)));
    IdtEntry        Entry[NUM] __attribute__((aligned(8)));

    static Idt* Instance;
};

#endif /* __IDT_H__ */
