#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__

#include <kernel.h>
#include <intmgr.h>
#include <shell.h>
#include <event.h>
#include <keycode.h>

class KeyPressEvent : public Event
{
public:
    KeyPressEvent(int8 code) : KeyCode(code) {
        Id = KEY_PRESS_EVENT;
    }
    int8 getKeyCode(void) const {return KeyCode;}

private: 
    int8 KeyCode;
};

class KeyReleaseEvent : public Event
{
public:
    KeyReleaseEvent(int8 code) : Code(code) {
        Id = KEY_RELEASE_EVENT;
    }
    int8 getKeyCode(void) const {return Code;}

private:
    int8 Code;
};

class KeyboardInterruptHandler : public InterruptHandler
{
public:
    KeyboardInterruptHandler(void) : State(START), isBreak(false) {}

    void operator()(uint32 intNum) {
        uint8 data = IoPortLib::in8(IoPortLib::KBD_DATA);
        IntMgr::getInstance()->setEoi(IntMgr::KEYBOARD_IRQ);
        sendEvent(data);
    }

private:
    static const int8 KeyCodeMap[];
    static const int8 SpecialKeyCodeMap[];

    enum KeyboardState {
        START   = 0,
        SPECIAL = 1,
        PAUSE1  = 2,
        PAUSE2  = 3,
    };
    KeyboardState State;
    bool          isBreak;

    void sendEvent(uint8 input);
};

class KeyMapper
{
public:
    KeyMapper(void) : 
        AsciiTable(JP104Map), ShiftAsciiTable(JP104ShiftMap),
        isShiftDown(false), isCtrlDown(false), isAltDown(false),
        isCapsLocked(false), isNumLocked(false), isScrollLocked(false) {}
    int toAscii(int8 keycode);
    void setShift(bool enable) {isShiftDown = enable;}
    void setCtrl(bool enable)  {isCtrlDown  = enable;}
    void setAlt(bool enable)   {isAltDown   = enable;}

private:
    const int* AsciiTable;
    const int* ShiftAsciiTable;

    bool isShiftDown, isCtrlDown, isAltDown;
    bool isCapsLocked, isNumLocked, isScrollLocked;

    static const int JP104Map[];
    static const int JP104ShiftMap[];
};

#endif /*__KEYBOARD_H__ */
