#ifndef __MUTEX_H__
#define __MUTEX_H__

#include <semaphore.h>
#include <task.h>

class Mutex : public Semaphore 
{
public:
    Mutex(void) : Semaphore(1), Owner(0) {}

    int lock(void) {
        wait(); 
        Owner = TaskScheduler::getInstance()->getCurrentTask();
        return OK;
    }

    int unlock(void) {
        int result = ERROR;
        if ((getValue() == 0) &&
            (Owner == TaskScheduler::getInstance()->getCurrentTask())) {
            post();
            result = OK;
        }
        return result;
    }

    // int trylock(void);

private:
    Task* Owner;
};

#endif /* __MUTEX_H__ */
