#include <semaphore.h>
#include <task.h>

void Semaphore::wait(void) {
    IntMgr::disable();
    if (Value == 0) {
        TaskScheduler* scheduler = TaskScheduler::getInstance();
        Task* cur_task = scheduler->getCurrentTask();
        WaitQueue.enqueue(*cur_task);
        scheduler->sleep(*cur_task);
    }
    --Value;
    IntMgr::enable();;
}

void Semaphore::post(void) {
    IntMgr::disable();
    if (!WaitQueue.isEmpty()) {
        Task* task = reinterpret_cast<Task*>(WaitQueue.dequeue());
        TaskScheduler::getInstance()->wakeup(*task);
    }
    ++Value;
    IntMgr::enable();
}
