/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.flow;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.container.ContainerException;
import org.arefgard.container.aop.MethodInvocation;
import org.arefgard.container.flow.Call;
import org.arefgard.container.flow.Decision;
import org.arefgard.container.flow.Interface;
import org.arefgard.container.flow.Invoke;
import org.arefgard.container.flow.Navigation;
import org.arefgard.container.flow.Receive;
import org.arefgard.container.flow.Reply;
import org.arefgard.container.flow.Sequence;
import org.arefgard.container.flow.Throw;
import org.arefgard.container.flow.UseCaseFlowExecutor;
import org.arefgard.container.flow.UseCaseFlowParseException;
import org.arefgard.container.flow.Wait;
import org.arefgard.container.flow.While;
import org.arefgard.container.util.MessageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UseCaseFlowExecutorImpl
implements UseCaseFlowExecutor {
    private Log log = LogFactory.getLog(UseCaseFlowExecutorImpl.class);
    private static String SEQUENCE_NODE_RECEIVE = "receive";
    private static String SEQUENCE_NODE_INVOKE = "invoke";
    private static String SEQUENCE_NODE_REPLY = "reply";
    private static String SEQUENCE_NODE_THROW = "throw";
    private static String SEQUENCE_NODE_DICISION = "decision";
    private static String SEQUENCE_NODE_WHILE = "while";
    private static String SEQUENCE_NODE_CALL = "call";
    private static String SEQUENCE_NODE_WAIT = "wait";
    private static String XPATH_NODE_INTERFACE = "/usecase/interfaces/interface";
    private static String XPATH_NODE_SEQUENCE = "/usecase/sequence/child::*";
    private static String XPATH_NODE_PARAMETER = "parameter";
    private static String XPATH_NODE_NAVIGATION = "navigation";
    private static String XPATH_ATTR_NAME = "string(@name)";
    private static String XPATH_ATTR_TYPE = "string(@type)";
    private static String XPATH_ATTR_METHOD = "string(@method)";
    private static String XPATH_ATTR_CONDITION = "string(@condition)";
    private static String XPATH_ATTR_NEXTTO = "string(@nextTo)";
    private static String XPATH_ATTR_TIME = "string(@time)";
    private XPathExpression XPATH_INTERFACE;
    private XPathExpression XPATH_SEQUENCE;
    private XPathExpression XPATH_PARAMETER;
    private XPathExpression XPATH_NAVIGATION;
    private XPathExpression XPATH_NAME;
    private XPathExpression XPATH_TYPE;
    private XPathExpression XPATH_METHOD;
    private XPathExpression XPATH_CONDITION;
    private XPathExpression XPATH_NEXTTO;
    private XPathExpression XPATH_TIME;
    private Map<String, Interface> input = null;
    private Map<String, Sequence> sequence = null;
    private Map<String, Object> output = null;
    private String flowPath = null;
    private String statringPoint = null;

    public UseCaseFlowExecutorImpl(String flowPath) throws ContainerException {
        this.flowPath = flowPath;
        this.input = new HashMap<String, Interface>();
        this.sequence = new HashMap<String, Sequence>();
        this.output = new HashMap<String, Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            this.XPATH_INTERFACE = xpath.compile(XPATH_NODE_INTERFACE);
            this.XPATH_SEQUENCE = xpath.compile(XPATH_NODE_SEQUENCE);
            this.XPATH_PARAMETER = xpath.compile(XPATH_NODE_PARAMETER);
            this.XPATH_NAVIGATION = xpath.compile(XPATH_NODE_NAVIGATION);
            this.XPATH_NAME = xpath.compile(XPATH_ATTR_NAME);
            this.XPATH_TYPE = xpath.compile(XPATH_ATTR_TYPE);
            this.XPATH_METHOD = xpath.compile(XPATH_ATTR_METHOD);
            this.XPATH_CONDITION = xpath.compile(XPATH_ATTR_CONDITION);
            this.XPATH_NEXTTO = xpath.compile(XPATH_ATTR_NEXTTO);
            this.XPATH_TIME = xpath.compile(XPATH_ATTR_TIME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.parseUseCase();
    }

    public void execute() throws Exception {
        Receive start = (Receive)this.sequence.get(this.statringPoint);
        int i = 0;
        while (i < start.getParameterLength()) {
            start.getParameter(i);
            ++i;
        }
        String navi = start.getNextTo();
        Object result = null;
        block1: while (true) {
            Sequence sequenceDef;
            if ((sequenceDef = this.sequence.get(navi)) instanceof Invoke) {
                Invoke invokeDef = (Invoke)sequenceDef;
                Object obj = this.input.get(invokeDef.getType()).getValue();
                String method = invokeDef.getMethod();
                ArrayList<Object> paramList = new ArrayList<Object>();
                int i2 = 0;
                while (i2 < invokeDef.getParameterLength()) {
                    paramList.add(this.input.get(invokeDef.getParameter(i2)).getValue());
                    ++i2;
                }
                MethodInvocation invokeMethod = new MethodInvocation(obj);
                result = invokeMethod.execute(method, paramList);
                navi = invokeDef.getNextTo();
                continue;
            }
            if (sequenceDef instanceof Reply) {
                Reply replyDef = (Reply)sequenceDef;
                int i3 = 0;
                while (i3 < replyDef.getParameterLength()) {
                    String param = replyDef.getParameter(i3);
                    this.output.put(param, this.input.get(param).getValue());
                    ++i3;
                }
                break;
            }
            if (sequenceDef instanceof Throw) {
                Throw throwDef = (Throw)sequenceDef;
                throwDef.throwException();
                continue;
            }
            if (sequenceDef instanceof Decision) {
                Decision decisionDef = (Decision)sequenceDef;
                Navigation[] navis = decisionDef.getAllNavigations();
                int i4 = 0;
                int n = navis.length;
                while (true) {
                    if (i4 >= n) continue block1;
                    String left = navis[i4].getLeft();
                    if (left.equals("@return") && navis[i4].evaluate(result)) {
                        navi = navis[i4].getNextTo();
                        continue block1;
                    }
                    ++i4;
                }
            }
            if (sequenceDef instanceof While) continue;
            if (sequenceDef instanceof Call) {
                Call callDef = (Call)sequenceDef;
                String path = callDef.getPath();
                UseCaseFlowExecutorImpl exec = new UseCaseFlowExecutorImpl(path);
                exec.execute();
                continue;
            }
            if (!(sequenceDef instanceof Wait)) continue;
            Wait waitDef = (Wait)sequenceDef;
            navi = waitDef.execute();
        }
    }

    public Object getOutput(String key) {
        return this.output.get(key);
    }

    public void setInput(String key, Object obj) {
        Interface interfaceDef = this.input.get(key);
        interfaceDef.setValue(obj);
        this.input.put(key, interfaceDef);
    }

    private void parseUseCase() throws ContainerException {
        int i;
        InputStream is = ClassLoader.getSystemResourceAsStream(this.flowPath);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(this.flowPath);
        }
        if (is == null) {
            this.log.error((Object)MessageUtil.getMessage("USECASE.ERROR.NOTFOUND", this.flowPath));
            throw new UseCaseFlowParseException(MessageUtil.getMessage("USECASE.ERROR.NOTFOUND", this.flowPath));
        }
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)MessageUtil.getMessage("USECASE.ERROR.PARSE", new Object[0]), (Throwable)e);
            throw new UseCaseFlowParseException(MessageUtil.getMessage("USECASE.ERROR.PARSE", new Object[0]), e);
        }
        try {
            NodeList interfaces = (NodeList)this.XPATH_INTERFACE.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            while (i < interfaces.getLength()) {
                Node interfaceNode = interfaces.item(i);
                String name = this.getName(interfaceNode);
                String type = this.getType(interfaceNode);
                Interface interfaceDef = new Interface(name, type);
                this.input.put(name, interfaceDef);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)MessageUtil.getMessage("USECASE.ERROR.PARSE", new Object[0]), (Throwable)e);
            throw new UseCaseFlowParseException(MessageUtil.getMessage("USECASE.ERROR.PARSE", new Object[0]), e);
        }
        try {
            NodeList sequences = (NodeList)this.XPATH_SEQUENCE.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            while (i < sequences.getLength()) {
                String type;
                String param;
                Node parameterNode;
                NodeList parameters;
                String name;
                Node sequenceNode = sequences.item(i);
                String nodeName = sequenceNode.getNodeName();
                if (nodeName.endsWith(SEQUENCE_NODE_RECEIVE)) {
                    name = this.getName(sequenceNode);
                    Receive receiveDef = new Receive(name);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    int n = parameters.getLength();
                    while (j < n) {
                        parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        receiveDef.addParameter(param);
                        ++j;
                    }
                    receiveDef.setNextTo(this.getNextTo(sequenceNode));
                    this.sequence.put(name, receiveDef);
                    this.statringPoint = name;
                } else if (nodeName.endsWith(SEQUENCE_NODE_INVOKE)) {
                    name = this.getName(sequenceNode);
                    type = this.getType(sequenceNode);
                    String method = this.getMethod(sequenceNode);
                    Invoke invokeDef = new Invoke(name, type, method);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    int n = parameters.getLength();
                    while (j < n) {
                        parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        invokeDef.addParameter(param);
                        ++j;
                    }
                    invokeDef.setNextTo(this.getNextTo(sequenceNode));
                    this.sequence.put(name, invokeDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_REPLY)) {
                    name = this.getName(sequenceNode);
                    Reply replyDef = new Reply(name);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    int n = parameters.getLength();
                    while (j < n) {
                        parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        replyDef.addParameter(param);
                        ++j;
                    }
                    this.sequence.put(name, replyDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_THROW)) {
                    name = this.getName(sequenceNode);
                    type = this.getType(sequenceNode);
                    Throw throwDef = new Throw(name, type);
                    this.sequence.put(name, throwDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_DICISION)) {
                    name = this.getName(sequenceNode);
                    Decision decisionDef = new Decision(name);
                    NodeList navigations = (NodeList)this.XPATH_NAVIGATION.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    int n = navigations.getLength();
                    while (j < n) {
                        Node navi = navigations.item(j);
                        String condition = this.getCondition(navi);
                        String nextTo = this.getNextTo(navi);
                        decisionDef.addNavigation(new Navigation(condition, nextTo));
                        ++j;
                    }
                    this.sequence.put(name, decisionDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_WHILE)) {
                    name = this.getName(sequenceNode);
                    While whileDef = new While(name);
                    whileDef.setNextTo(this.getNextTo(sequenceNode));
                    Node navi = (Node)this.XPATH_NAVIGATION.evaluate(sequenceNode, XPathConstants.NODE);
                    String condition = this.getCondition(navi);
                    String nextTo = this.getNextTo(navi);
                    whileDef.setNavigation(new Navigation(condition, nextTo));
                    this.sequence.put(name, whileDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_CALL)) {
                    name = this.getName(sequenceNode);
                    Call callDef = new Call(name);
                    callDef.setType(this.getType(sequenceNode));
                    callDef.setNextTo(this.getNextTo(sequenceNode));
                    this.sequence.put(name, callDef);
                } else if (nodeName.endsWith(SEQUENCE_NODE_WAIT)) {
                    name = this.getName(sequenceNode);
                    Wait waitDef = new Wait(name);
                    waitDef.setTime(this.getTime(sequenceNode));
                    waitDef.setNextTo(this.getNextTo(sequenceNode));
                    this.sequence.put(name, waitDef);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)MessageUtil.getMessage("USECASE.ERROR.PARSE", new Object[0]), (Throwable)e);
            throw new UseCaseFlowParseException(MessageUtil.getMessage("USECASE.ERROR.PARSE", new Object[0]), e);
        }
    }

    private String getName(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_NAME.evaluate(obj, XPathConstants.STRING);
    }

    private String getType(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_TYPE.evaluate(obj, XPathConstants.STRING);
    }

    private String getMethod(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_METHOD.evaluate(obj, XPathConstants.STRING);
    }

    private String getCondition(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_CONDITION.evaluate(obj, XPathConstants.STRING);
    }

    private String getNextTo(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_NEXTTO.evaluate(obj, XPathConstants.STRING);
    }

    private long getTime(Object obj) throws XPathExpressionException {
        return Long.parseLong((String)this.XPATH_TIME.evaluate(obj, XPathConstants.STRING));
    }
}

