package org.arefgard.container;

import java.util.Map;

public class DomainDef {
	private String name;
	private Map<String, BeanDef> beanRefs;
	
	public DomainDef(String name) {
		this.name = name;
		beanRefs = new java.util.HashMap<String, BeanDef>();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public void addBeanDef(BeanDef beanDef) {
		beanRefs.put(beanDef.getName(), beanDef);
	}
	
	public BeanDef getBeanDef(String name) {
		return beanRefs.get(name);
	}
	
	public BeanDef[] getBeanDefs() {
		return (BeanDef[])beanRefs.values().toArray();
	}
}
