package org.arefgard.container;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.arefgard.container.util.MessageUtil;

public class Reference {
	
	private static final String REFERENCE_PATTERN = "^[0-9a-zA-Z]+.[0-9a-zA-Z]+$|^[0-9a-zA-Z]+$";
	private String nameSpace = null;
	private String target = null;
	
	public Reference() {
	}
	
	public Reference(String path) throws IllegalReferenceException {
		try {
			if(path == null || path.equals("")) {
				throw new IllegalReferenceException(MessageUtil.getMessage(Constants.REFERENCE_ERROR_NOTFOUND));
			}
			Pattern pattern = Pattern.compile(REFERENCE_PATTERN);
			Matcher matcher = pattern.matcher(path);
			if(!matcher.find()) {
				throw new IllegalReferenceException(MessageUtil.getMessage(Constants.REFERENCE_ERROR_ILLEGAL, path));
			}
			StringTokenizer tokenizer = new StringTokenizer(path, ".");
			if(tokenizer.countTokens() == 1) {
				this.nameSpace = tokenizer.nextToken();
			}if(tokenizer.countTokens() == 2) {
				this.nameSpace = tokenizer.nextToken();
				this.target = tokenizer.nextToken();
			}
		}catch(IllegalReferenceException e) {
			throw e;
		}catch(Exception e) {
			throw new IllegalReferenceException(MessageUtil.getMessage(Constants.REFERENCE_ERROR_NOTFOUND), e);
		}
	}
	
	public String getReferencePath() throws IllegalReferenceException {
		if(this.nameSpace == null || this.nameSpace.equals("")) {
			throw new IllegalReferenceException(MessageUtil.getMessage(Constants.REFERENCE_ERROR_NOTFOUND));
		}else if(this.target == null || this.target.equals("")) {
			return this.nameSpace;
		}else {
			return nameSpace + "." + target;
		}
	}
	
	public String getNameSpace() {
		return this.nameSpace;
	}
	
	public void setNameSpace(String service) {
		this.nameSpace = service;
	}
	
	public String getTarget() {
		return this.target;
	}
	
	public void setTarget(String bean) {
		this.target = bean;
	}
	
	public String toString() {
		if(this.target != null) {
			return this.nameSpace + "." + this.target;
		}else {
			return this.nameSpace;
		}
	}

}
