package org.arefgard.container.flow;

public class Navigation {
	private String left;
	private String expr;
	private String right;
	private String nextTo;
	
	public Navigation() {
		
	}
	
	public Navigation(String condition, String nextTo) {
		
		int idx = condition.indexOf('<');
		
		if(condition.equals("@default")) {
			this.left = "@default";
		}else if(idx == -1) {
			idx = condition.indexOf('>');
			if(idx == -1) {
				idx = condition.indexOf('!');
				if(idx == -1) {
					idx = condition.indexOf('=');
					// ==
					this.left = condition.substring(0, idx);
					this.right = condition.substring(idx+2);
					this.expr = "==";
				}else {
					// !=
					this.left = condition.substring(0, idx);
					this.right = condition.substring(idx+2);
					this.expr = "!=";
				}
			}else {
				// > or >=
				if(condition.charAt(idx+1) == '=') {
					// <=
					this.left = condition.substring(0, idx);
					this.right = condition.substring(idx+2);
					this.expr = ">=";
				}else {
					// <
					this.left = condition.substring(0, idx);
					this.right = condition.substring(idx+1);
					this.expr = ">";
				}
			}
		}else {
			// < or <=
			if(condition.charAt(idx+1) == '=') {
				// <=
				this.left = condition.substring(0, idx);
				this.right = condition.substring(idx+2);
				this.expr = "<=";
			}else {
				// <
				this.left = condition.substring(0, idx);
				this.right = condition.substring(idx+1);
				this.expr = "<";
			}
		}
		
		// <, >, <=, >=, ==
		this.nextTo = nextTo;
	}
	
	public String getExpr() {
		return expr;
	}
	public void setExpr(String expr) {
		this.expr = expr;
	}
	public String getLeft() {
		return left;
	}
	public void setLeft(String left) {
		this.left = left;
	}
	public String getRight() {
		return right;
	}
	public void setRight(String right) {
		this.right = right;
	}
	public String getNextTo() {
		return nextTo;
	}
	public void setNextTo(String nextTo) {
		this.nextTo = nextTo;
	}
	
	public boolean evaluate(Object obj) {
		if(obj instanceof Boolean) {
			// ==, !=のみがありえる
			Boolean value = null;
			if(expr.equals("==") && right.equals("true") ||
				expr.endsWith("!=") && right.equals("false")) {
				value = new Boolean(true);
			}else {
				value = new Boolean(false);
			}
			return value.equals(obj);
		}else if(obj instanceof Integer ||
				  obj instanceof Short   ||
				  obj instanceof Byte    ||
				  obj instanceof Float   ||
				  obj instanceof Double) {
			// 数値比較
		}else {
			// ==, != 文字列比較
			if(expr.equals("==")) {
				return right.equals(obj);
			}else {
				return !right.equals(obj);
			}
		}
		
		
		return false;
	}
	
}
