package org.arefgard.container;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.Map;

import org.arefgard.business.domain.model.Customer;
import org.arefgard.business.domain.model.Employee;
import org.junit.Before;
import org.junit.Test;

public class SingletonIceryaContainerTest {

	IceryaContainer container = null;
	
	@Before
	public void setUp() throws Exception {
		try {
			ContainerFactory.initialize("files/test01/components.xml");
			container = ContainerFactory.newContainer();
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void createObjectFromString() {
		try {
			Employee obj = (Employee)container.create("global.employee");
			assertNotNull(obj);

			assertEquals(null, obj.getUserName());
			assertEquals(null, obj.getPassword());
			assertEquals(null, obj.getFirstName());
			assertEquals(null, obj.getLastName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void createObjectFromClassType() {
		try {
			Employee obj = (Employee)container.create(Employee.class);
			assertNotNull(obj);

			assertEquals(null, obj.getUserName());
			assertEquals(null, obj.getPassword());
			assertEquals(null, obj.getFirstName());
			assertEquals(null, obj.getLastName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void createObjectFromReference() {
		try {
			Employee obj = (Employee)container.create(new Reference("global.employee"));
			assertNotNull(obj);
			
			assertEquals(null, obj.getUserName());
			assertEquals(null, obj.getPassword());
			assertEquals(null, obj.getFirstName());
			assertEquals(null, obj.getLastName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void createObjectFromStringWithProperty() {
		try {
			Map<String, Object> property = new java.util.HashMap<String, Object>();
			property.put("userName", "00001");
			property.put("password", "p@ssw0rd");
			Employee obj = (Employee)container.create("global.employee",property);
			assertNotNull(obj);
			assertEquals("00001", obj.getUserName());
			assertEquals("p@ssw0rd", obj.getPassword());
			assertEquals(null, obj.getFirstName());
			assertEquals(null, obj.getLastName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void createObjectFromReferenceWithProperty() {
		try {
			Map<String, Object> property = new java.util.HashMap<String, Object>();
			property.put("userName", "00001");
			property.put("password", "p@ssw0rd");
			Employee obj = (Employee)container.create(new Reference("global.employee"),property);
			assertNotNull(obj);
			assertEquals("00001", obj.getUserName());
			assertEquals("p@ssw0rd", obj.getPassword());
			assertEquals(null, obj.getFirstName());
			assertEquals(null, obj.getLastName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void createServiceFromString() {
		try {
			BusinessService service = container.createService("account.signIn");
			assertNotNull(service);
			service.addInput("customerId", "00001");
			service.addInput("password", "p@ssw0rd");
			service.execute();
			Customer result = (Customer)service.getOutput("return");
			assertEquals("00001", result.getUserName());
			assertEquals("p@ssw0rd", result.getPassword());
		} catch (Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
}
