package org.arefgard.container.aop;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.Test;

public class ClassGeneratorTest {

	@Test
	public void generateEmptyObject() {
		try {
			TestClass1 obj = (TestClass1)ClassGenerator.generate("org.arefgard.container.aop.TestClass1");
			assertNotNull(obj);
			assertEquals(null, obj.getValue1());
			assertEquals(null, obj.getValue2());
			assertEquals(0, obj.getValue3());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void generateObjectWithProperty1() {
		try {
			String[] typelist = new String[] {"value1", "value2", "value3"};
			Object[] objlist = new Object[] {"value1", "value2", new Integer(2)};
			TestClass1 obj = (TestClass1)ClassGenerator.generate("org.arefgard.container.aop.TestClass1", typelist, objlist);
			assertNotNull(obj);
			assertEquals("value1", obj.getValue1());
			assertEquals("value2", obj.getValue2());
			assertEquals(2, obj.getValue3());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void generateObjectWithProperty2() {
		try {
			String[] typelist = new String[] {"value1", "value2", "value3", "value4", "value5", "value6", "value7"};
			Object[] objlist = new Object[] {new Long(1000), new Character('a'), new Double(5.5), new Short((short)3), new Byte((byte)1), new Float(10.2F), "HOGE"};
			TestClass2 obj = (TestClass2)ClassGenerator.generate("org.arefgard.container.aop.TestClass2", typelist, objlist);
			assertNotNull(obj);
			assertEquals(1000L, obj.getValue1());
			assertEquals('a', obj.getValue2());
			assertEquals(5.5, obj.getValue3());
			assertEquals(3, obj.getValue4());
			assertEquals(1, obj.getValue5());
			assertEquals(10.2F, obj.getValue6());
			assertEquals("HOGE", obj.getValue7());
		}catch(Exception e) {
			fail("ERROR" + e);
		}
	}
}

class TestClass1 {
	private String value1 = null;
	private String value2 = null;
	private int value3;
	public TestClass1() {	
	}
	
	TestClass1(String value1, String value2, int value3) {
		this.value1 = value1;
		this.value2 = value2;
		this.value3 = value3;
	}
	public String getValue1() {
		return value1;
	}
	public void setValue1(String value1) {
		this.value1 = value1;
	}
	public String getValue2() {
		return value2;
	}
	public void setValue2(String value2) {
		this.value2 = value2;
	}
	public int getValue3() {
		return value3;
	}
	public void setValue3(int value3) {
		this.value3 = value3;
	}
}

class TestClass2 {
	private long value1;
	private char value2;
	private double value3;
	private short value4;
	private byte value5;
	private float value6;
	private String value7;
	
	public long getValue1() {
		return value1;
	}
	public void setValue1(long value1) {
		this.value1 = value1;
	}
	public char getValue2() {
		return value2;
	}
	public void setValue2(char value2) {
		this.value2 = value2;
	}
	public double getValue3() {
		return value3;
	}
	public void setValue3(double value3) {
		this.value3 = value3;
	}
	public short getValue4() {
		return value4;
	}
	public void setValue4(short value4) {
		this.value4 = value4;
	}
	public byte getValue5() {
		return value5;
	}
	public void setValue5(byte value5) {
		this.value5 = value5;
	}
	public float getValue6() {
		return value6;
	}
	public void setValue6(float value6) {
		this.value6 = value6;
	}
	public String getValue7() {
		return value7;
	}
	public void setValue7(String value7) {
		this.value7 = value7;
	}
	
}
