package org.arefgard.container.flow;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.arefgard.business.domain.model.Customer;
import org.arefgard.container.flow.UseCaseFlowExecutorImpl;
import org.junit.Test;


public class ServiceWorkflowExecutorTest {

	@Test
	public void executeWorkflow() {
		try {
			UseCaseFlowExecutorImpl exec = new UseCaseFlowExecutorImpl("files/test01/signIn.xml");
			Customer customer = new Customer();
			customer.setUserName("hoge");
			customer.setPassword("hoge");
			Customer attestedCustomer = new Customer();
			attestedCustomer.setUserName("hoge");
			attestedCustomer.setPassword("hoge");
			exec.setInput("customer", customer);
			exec.setInput("attestedCustomer", attestedCustomer);
			exec.execute();
			Customer result = (Customer)exec.getOutput("attestedCustomer");
			assertEquals("hoge", result.getUserName());
		}catch(Exception e) {
			e.printStackTrace();
			fail("error" + e);
		}
	}
	
	@Test
	public void executeWorkflow2() {
		try {
			UseCaseFlowExecutorImpl exec = new UseCaseFlowExecutorImpl("files/test01/signIn.xml");
			Customer customer = new Customer();
			customer.setUserName("hoge");
			customer.setPassword("hoge");
			Customer attestedCustomer = new Customer();
			attestedCustomer.setUserName("hoge");
			attestedCustomer.setPassword("uhe");
			exec.setInput("customer", customer);
			exec.setInput("attestedCustomer", attestedCustomer);
			exec.execute();
			fail("error");
		}catch(Exception e) {
			assertTrue(true);
		}
	}
	
	
}
