/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.util.ClassUtil;

public abstract class HotdeployUtil {
    private static Boolean hotdeploy;

    protected HotdeployUtil() {
    }

    public static void setHotdeploy(boolean hotdeploy) {
        HotdeployUtil.hotdeploy = hotdeploy;
    }

    public static void clearHotdeploy() {
        hotdeploy = null;
    }

    public static boolean isHotdeploy() {
        if (hotdeploy != null) {
            return hotdeploy;
        }
        S2ContainerBehavior.Provider provider = S2ContainerBehavior.getProvider();
        return provider instanceof HotdeployBehavior;
    }

    public static void start() {
        if (HotdeployUtil.isHotdeploy()) {
            ((HotdeployBehavior)S2ContainerBehavior.getProvider()).start();
        }
    }

    public static void stop() {
        if (HotdeployUtil.isHotdeploy()) {
            ((HotdeployBehavior)S2ContainerBehavior.getProvider()).stop();
        }
    }

    public static Object rebuildValue(Object value) {
        if (HotdeployUtil.isHotdeploy()) {
            return HotdeployUtil.rebuildValueInternal(value);
        }
        return value;
    }

    protected static Object rebuildValueInternal(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (HotdeployUtil.isSimpleValueType(valueClass)) {
            return value;
        }
        if (valueClass.isArray()) {
            return HotdeployUtil.rebuildArray(value);
        }
        if (valueClass == ArrayList.class) {
            return HotdeployUtil.rebuildArrayList((ArrayList)value);
        }
        if (Collection.class.isAssignableFrom(valueClass)) {
            return HotdeployUtil.rebuildCollection((Collection)value);
        }
        if (Map.class.isAssignableFrom(valueClass)) {
            return HotdeployUtil.rebuildMap((Map)value);
        }
        return HotdeployUtil.rebuildBean(value);
    }

    protected static Object rebuildArray(Object value) {
        Class clazz = value.getClass().getComponentType();
        if (!clazz.isPrimitive()) {
            clazz = ClassUtil.forName(clazz.getName());
        }
        int size = Array.getLength(value);
        Object array = Array.newInstance(clazz, size);
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, HotdeployUtil.rebuildValueInternal(Array.get(value, i)));
        }
        return array;
    }

    protected static ArrayList rebuildArrayList(ArrayList value) {
        ArrayList<Object> arrayList = new ArrayList<Object>(value.size());
        for (int i = 0; i < value.size(); ++i) {
            arrayList.add(HotdeployUtil.rebuildValueInternal(value.get(i)));
        }
        return arrayList;
    }

    protected static Collection rebuildCollection(Collection value) {
        Collection collection = (Collection)ClassUtil.newInstance(value.getClass());
        Iterator i = value.iterator();
        while (i.hasNext()) {
            collection.add(HotdeployUtil.rebuildValueInternal(i.next()));
        }
        return collection;
    }

    protected static Map rebuildMap(Map value) {
        Map map = (Map)ClassUtil.newInstance(value.getClass());
        Iterator i = value.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            map.put(HotdeployUtil.rebuildValueInternal(entry.getKey()), HotdeployUtil.rebuildValueInternal(entry.getValue()));
        }
        return map;
    }

    protected static Object rebuildBean(Object value) {
        Object bean = ClassUtil.newInstance(value.getClass().getName());
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(value.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
        int propertyDescSize = srcBeanDesc.getPropertyDescSize();
        for (int i = 0; i < propertyDescSize; ++i) {
            PropertyDesc destPropertyDesc;
            String propertyName;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(i);
            if (!srcPropertyDesc.hasReadMethod() || !destBeanDesc.hasPropertyDesc(propertyName = srcPropertyDesc.getPropertyName()) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(propertyName)).hasWriteMethod()) continue;
            destPropertyDesc.setValue(bean, HotdeployUtil.rebuildValueInternal(srcPropertyDesc.getValue(value)));
        }
        return bean;
    }

    public static boolean isSimpleValueType(Class type) {
        return type == String.class || type == Boolean.class || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type);
    }
}

