/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.cooldeploy.S2ContainerFactoryCoolProvider;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.warmdeploy.WarmdeployBehavior;
import org.seasar.framework.util.FieldUtil;

public class SmartDeployUtil {
    private SmartDeployUtil() {
    }

    public static boolean isSmartdeployMode(S2Container container) {
        return SmartDeployUtil.isHotdeployMode(container) || SmartDeployUtil.isCooldeployMode(container) || SmartDeployUtil.isWarmdeployMode(container);
    }

    public static boolean isHotdeployMode(S2Container container) {
        return HotdeployUtil.isHotdeploy();
    }

    public static boolean isCooldeployMode(S2Container container) {
        BeanDesc bd = BeanDescFactory.getBeanDesc(S2ContainerFactory.class);
        S2ContainerFactory.Provider provider = (S2ContainerFactory.Provider)FieldUtil.get(bd.getField("provider"), null);
        return provider instanceof S2ContainerFactoryCoolProvider;
    }

    public static boolean isWarmdeployMode(S2Container container) {
        S2ContainerBehavior.Provider provider = S2ContainerBehavior.getProvider();
        return provider instanceof WarmdeployBehavior;
    }

    public static String getDeployMode(S2Container container) {
        if (SmartDeployUtil.isHotdeployMode(container)) {
            return "Hot Deploy";
        }
        if (SmartDeployUtil.isCooldeployMode(container)) {
            return "Cool Deploy";
        }
        if (SmartDeployUtil.isWarmdeployMode(container)) {
            return "Warm Deploy";
        }
        return "Normal Mode";
    }
}

