/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.message;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.message.MessageResourceBundleImpl;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.PropertiesUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.URLUtil;

public class MessageResourceBundleFacade {
    private File file;
    private long lastModified;
    private MessageResourceBundle bundle;
    private MessageResourceBundleFacade parent;

    public MessageResourceBundleFacade(URL url) {
        this.setup(url);
    }

    public synchronized MessageResourceBundle getBundle() {
        if (this.isModified()) {
            this.bundle = MessageResourceBundleFacade.createBundle(this.file);
        }
        if (this.parent != null) {
            this.bundle.setParent(this.parent.getBundle());
        }
        return this.bundle;
    }

    public synchronized MessageResourceBundleFacade getParent() {
        return this.parent;
    }

    public synchronized void setParent(MessageResourceBundleFacade parent) {
        this.parent = parent;
    }

    protected boolean isModified() {
        return this.file != null && this.file.lastModified() > this.lastModified;
    }

    protected void setup(URL url) {
        AssertionUtil.assertNotNull("url", url);
        this.file = ResourceUtil.getFile(url);
        if (this.file != null) {
            this.lastModified = this.file.lastModified();
            this.bundle = MessageResourceBundleFacade.createBundle(this.file);
        } else {
            this.bundle = MessageResourceBundleFacade.createBundle(url);
        }
        if (this.parent != null) {
            this.bundle.setParent(this.parent.getBundle());
        }
    }

    protected static MessageResourceBundle createBundle(File file) {
        return new MessageResourceBundleImpl(MessageResourceBundleFacade.createProperties(file));
    }

    protected static MessageResourceBundle createBundle(URL url) {
        return new MessageResourceBundleImpl(MessageResourceBundleFacade.createProperties(url));
    }

    protected static Properties createProperties(File file) {
        return MessageResourceBundleFacade.createProperties(FileInputStreamUtil.create(file));
    }

    protected static Properties createProperties(URL url) {
        return MessageResourceBundleFacade.createProperties(URLUtil.openStream(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties createProperties(InputStream is) {
        AssertionUtil.assertNotNull("is", is);
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        try {
            Properties properties = new Properties();
            PropertiesUtil.load(properties, is);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            InputStreamUtil.close(is);
        }
    }
}

