/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;

class ArgTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
        if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        int argIndx = 1;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                if (arg instanceof Collection && this.argTypes[i] != 2003) {
                    Collection entries = (Collection)arg;
                    Iterator it = entries.iterator();
                    while (it.hasNext()) {
                        Object entry = it.next();
                        StatementCreatorUtils.setParameterValue(ps, argIndx++, this.argTypes[i], null, entry);
                    }
                    continue;
                }
                StatementCreatorUtils.setParameterValue(ps, argIndx++, this.argTypes[i], null, arg);
            }
        }
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

