/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.flow.core;

import java.util.HashMap;
import java.util.Map;
import org.arefgard.icerya.flow.core.UsecaseFlow;
import org.arefgard.icerya.flow.core.UsecaseFlowDefinitionReader;
import org.arefgard.icerya.flow.exception.UsecaseFlowDefinitionParseException;
import org.arefgard.icerya.flow.exception.UsecaseFlowException;

public class UsecaseFlowFactory {
    private static Map<String, UsecaseFlow> cache = new HashMap<String, UsecaseFlow>();

    public static synchronized UsecaseFlow create(String path) throws UsecaseFlowException {
        UsecaseFlow result = null;
        if (cache.containsKey(path)) {
            result = cache.get(path);
        } else {
            try {
                result = new UsecaseFlow();
                UsecaseFlowDefinitionReader reader = new UsecaseFlowDefinitionReader(result);
                reader.parse(path);
                cache.put(path, result);
            }
            catch (Exception e) {
                throw new UsecaseFlowDefinitionParseException("PATH[" + path + "] is illegal path.", e);
            }
        }
        return result;
    }
}

