/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.BeanDefinitionParseException;
import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.IceryaContainer;
import org.arefgard.icerya.container.parse.XmlBeanDefinitionReader;

public class ContainerFactory {
    private static final Log log = LogFactory.getLog(ContainerFactory.class);
    private static Map<String, IceryaContainer> cache = new HashMap<String, IceryaContainer>();
    private static Map<String, String> contexts = new HashMap<String, String>();

    public static synchronized IceryaContainer create(String path) throws ContainerException {
        ContainerFactory.initialize(path);
        return cache.get(path);
    }

    private static synchronized void initialize(String path) throws ContainerException {
        if (cache.containsKey(path)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("contaier file [" + path + "] is cached."));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("container file [" + path + "] is not cached."));
            }
            try {
                IceryaContainer result = new IceryaContainer();
                XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(result);
                reader.parse(path);
                cache.put(path, result);
                contexts.put(result.getContext(), path);
            }
            catch (Exception e) {
                log.error((Object)("PATH[" + path + "] is illegal path."), (Throwable)e);
                throw new BeanDefinitionParseException("PATH[" + path + "] is illegal path.", e);
            }
        }
    }

    public static synchronized IceryaContainer getContainer(String context) throws ContainerException {
        return cache.get(contexts.get(context));
    }

    public static synchronized IceryaContainer create() throws ContainerException {
        return new IceryaContainer();
    }
}

