/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.cache.CacheStrategy;
import org.arefgard.icerya.container.def.BeanDef;
import org.arefgard.icerya.container.injection.InjectionStrategy;
import org.arefgard.icerya.container.injection.impl.ParameterizedInjectionStrategy;
import org.arefgard.icerya.container.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IceryaContainer {
    private static final Log log = LogFactory.getLog(IceryaContainer.class);
    private String context = null;
    private Map<String, BeanDef> internal = new HashMap<String, BeanDef>();
    private List<IceryaContainer> includeContainer = new ArrayList<IceryaContainer>();
    private Map<String, String> meta = new HashMap<String, String>();

    IceryaContainer() {
    }

    public void addBeanDef(String beanId, String cls) {
        BeanDef beanDef = new BeanDef();
        beanDef.setBeanId(beanId);
        beanDef.setContainer(this);
        this.internal.put(beanId, beanDef);
    }

    public void addBeanDef(BeanDef entity) {
        entity.setContainer(this);
        this.internal.put(entity.getBeanId(), entity);
    }

    public BeanDef getBeanDef(String id) {
        return this.internal.get(id);
    }

    public Map<String, BeanDef> getAllBeanDef() {
        return this.internal;
    }

    public Object getBean(String id) throws ContainerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"---[get bean]---");
        }
        if (id == null || id.equals("")) {
            log.error((Object)("Illegal Argument[id=" + id + "]."));
            throw new ContainerException("Illegal Argument[id=" + id + "].");
        }
        BeanDef beanDef = this.internal.get(id);
        if (beanDef == null) {
            int length = this.includeContainer.size();
            int i = 0;
            while (i < length) {
                IceryaContainer container = this.includeContainer.get(i);
                beanDef = container.getBeanDef(id);
                if (beanDef != null) break;
                ++i;
            }
        }
        if (beanDef == null) {
            log.error((Object)("ID[" + id + "] is not exitst."));
            throw new ContainerException("ID[" + id + "] is not exist.");
        }
        Object result = null;
        CacheStrategy cache = beanDef.getCacheStrategy();
        result = cache.getCache();
        if (result == null) {
            InjectionStrategy injection = beanDef.getInjectionStrategy();
            if (injection != null) {
                injection.inject(beanDef);
                result = injection.getInjectObject();
            }
            cache.save(result);
            return result;
        }
        return result;
    }

    public <T> T getBean(String id, Class<T> cls) throws ContainerException {
        return (T)this.getBean(id);
    }

    public Object getBean(String id, Object ... args) throws ContainerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"---[get bean]---");
        }
        if (id == null || id.equals("")) {
            log.error((Object)("Illegal Argument[id=" + id + "]."));
            throw new ContainerException("Illegal Argument[id=" + id + "].");
        }
        BeanDef beanDef = this.internal.get(id);
        if (beanDef == null) {
            int length = this.includeContainer.size();
            int i = 0;
            while (i < length) {
                IceryaContainer container = this.includeContainer.get(i);
                beanDef = container.getBeanDef(id);
                if (beanDef != null) break;
                ++i;
            }
        }
        if (beanDef == null) {
            log.error((Object)("ID[" + id + "] is not exitst."));
            throw new ContainerException("ID[" + id + "] is not exist.");
        }
        Object result = null;
        CacheStrategy cache = beanDef.getCacheStrategy();
        result = cache.getCache();
        if (result == null) {
            InjectionStrategy injection = beanDef.getInjectionStrategy();
            if (injection instanceof ParameterizedInjectionStrategy) {
                ((ParameterizedInjectionStrategy)injection).add(args);
            }
            if (injection != null) {
                injection.inject(beanDef);
                result = injection.getInjectObject();
            }
            cache.save(result);
            return result;
        }
        return result;
    }

    public <T> T getBean(String id, Class<T> cls, Object ... args) throws ContainerException {
        return (T)this.getBean(id, args);
    }

    public void injectDependency(String id, Object obj) throws ContainerException {
        if (!this.internal.containsKey(id)) {
            throw new ContainerException("");
        }
        BeanDef beanDef = this.internal.get(id);
        InjectionStrategy injection = beanDef.getInjectionStrategy();
        injection.setInjectObject(obj);
        injection.inject(beanDef);
    }

    public boolean containsBean(Object key) {
        return this.internal.containsKey(key);
    }

    protected void finalize() throws Throwable {
        Set<String> keys = this.internal.keySet();
        for (String key : keys) {
            BeanDef beanDef = this.internal.get(key);
            String destroyMethod = beanDef.getDestroyMethod();
            Object obj = beanDef.getCacheStrategy().getCache();
            if (destroyMethod == null || destroyMethod.equals("")) continue;
            ReflectionUtil.execute(obj, destroyMethod, null);
        }
        super.finalize();
    }

    public void addContainer(IceryaContainer includeContainer) {
        this.includeContainer.add(includeContainer);
    }

    public String getMetaDefinition(String key) {
        return this.meta.get(key);
    }

    public void addMetaDefinition(String key, String value) {
        this.meta.put(key, value);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void weaving() {
    }
}

