/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.injection.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.def.BeanDef;
import org.arefgard.icerya.container.def.ConstructorArgDef;
import org.arefgard.icerya.container.def.ResourceDef;
import org.arefgard.icerya.container.def.ValueResourceDef;
import org.arefgard.icerya.container.injection.impl.SetterInjectionStrategy;
import org.arefgard.icerya.container.util.ReflectionUtil;

public class ConstructorInjectionStrategy
extends SetterInjectionStrategy {
    private static final Log log = LogFactory.getLog(ConstructorInjectionStrategy.class);

    protected void generate(BeanDef beanDef) throws ContainerException {
        block8: {
            try {
                if (this.injectObject != null) break block8;
                if (beanDef == null) {
                    log.error((Object)"Illegal BeanDef.");
                    throw new ContainerException("Illegal Argument.");
                }
                String id = beanDef.getBeanId();
                Class<?> cls = null;
                try {
                    cls = Class.forName(beanDef.getBeanClass());
                }
                catch (Exception e) {
                    throw new ContainerException("class[" + beanDef.getBeanClass() + "] is not found");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  id = " + id + ", className = " + cls.getName()));
                }
                List<ConstructorArgDef> argsList = beanDef.getConstructorArgs();
                Object[] args = new Object[argsList.size()];
                int i = 0;
                while (i < args.length) {
                    ResourceDef resourceDef = argsList.get(i).getResourceDef();
                    if (resourceDef instanceof ValueResourceDef) {
                        ValueResourceDef valueDef = (ValueResourceDef)resourceDef;
                        args[i] = valueDef.getValue();
                    }
                    ++i;
                }
                this.injectObject = ReflectionUtil.generate(cls, args);
            }
            catch (Exception e) {
                throw new ContainerException(e);
            }
        }
    }

    protected void injection(BeanDef beanDef) throws ContainerException {
        super.injection(beanDef);
    }
}

