/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.parse;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arefgard.icerya.container.BeanDefinitionParseException;
import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.IceryaContainer;
import org.arefgard.icerya.container.def.BeanDef;
import org.arefgard.icerya.container.def.BeanResourceDef;
import org.arefgard.icerya.container.def.ConstructorArgDef;
import org.arefgard.icerya.container.def.PropertyDef;
import org.arefgard.icerya.container.def.ReferenceResourceDef;
import org.arefgard.icerya.container.def.ValueResourceDef;
import org.arefgard.icerya.container.parse.BeanHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlBeanDefinitionReader {
    private IceryaContainer container;

    public XmlBeanDefinitionReader(IceryaContainer container) {
        this.container = container;
    }

    public void parse(String path) throws ContainerException {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        String head = null;
        try {
            try {
                is = ClassLoader.getSystemResourceAsStream(path);
                if (is == null) {
                    path.getClass().getClassLoader().getResourceAsStream(path);
                }
                os = new ByteArrayOutputStream();
                int len = 0;
                byte[] buf = new byte[4096];
                len = is.read(buf);
                os.write(buf, 0, len);
                head = os.toString();
            }
            catch (Exception e) {
                throw new BeanDefinitionParseException(e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        if (head == null) {
            throw new BeanDefinitionParseException();
        }
        if (head.indexOf("<container") <= 0) {
            throw new BeanDefinitionParseException();
        }
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new BeanDefinitionParseException("Creation XMLReader failed.", e);
        }
        reader.setContentHandler(new BeanHandler(this.container));
        is = ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        try {
            try {
                reader.parse(new InputSource(is));
            }
            catch (FileNotFoundException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
            catch (IOException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
            catch (SAXException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Map<String, BeanDef> beanMap = this.container.getAllBeanDef();
        Set<String> keys1 = beanMap.keySet();
        for (String key1 : keys1) {
            BeanDef beanDef = beanMap.get(key1);
            Map<String, PropertyDef> properties = beanDef.getProperties();
            Set<String> keys2 = properties.keySet();
            for (String key2 : keys2) {
                PropertyDef propertyDef = beanDef.getProperty(key2);
                if (!(propertyDef.getResourceDef() instanceof ReferenceResourceDef) && !(propertyDef.getResourceDef() instanceof BeanResourceDef)) continue;
            }
            List<ConstructorArgDef> constructorArgs = beanDef.getConstructorArgs();
            int length = constructorArgs.size();
            int i = 0;
            while (i < length) {
                ConstructorArgDef constructorArgDef = constructorArgs.get(i);
                ValueResourceDef valueResourceDef = (ValueResourceDef)constructorArgDef.getResourceDef();
                if (beanMap.containsKey(valueResourceDef.getValue())) {
                    ReferenceResourceDef refDef = new ReferenceResourceDef((String)((ValueResourceDef)constructorArgDef.getResourceDef()).getValue());
                    constructorArgDef.setResourceDef(refDef);
                    constructorArgDef.setType(this.container.getBean(refDef.getRef()).getClass());
                }
                ++i;
            }
        }
        this.container.weaving();
    }
}

