package org.arefgard.icerya.container;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.cache.CacheStrategy;
import org.arefgard.icerya.container.def.BeanDef;
import org.arefgard.icerya.container.injection.InjectionStrategy;
import org.arefgard.icerya.container.injection.impl.ParameterizedInjectionStrategy;
import org.arefgard.icerya.container.util.ReflectionUtil;

/**
 * DIReiB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class IceryaContainer {

	/** K[ */
	private static final Log log = LogFactory.getLog(IceryaContainer.class);
	
	/** ReLXg */
	private String context = null;
	
	/** Rei(BeanIdL[Bean`ێ) */
	private Map<String, BeanDef> internal = new java.util.HashMap<String, BeanDef>();
	
	/** CN[hRei */
	private List<IceryaContainer> includeContainer = new java.util.ArrayList<IceryaContainer>();
	
	/** Rei^` */
	private Map<String, String> meta = new java.util.HashMap<String, String>();
	
	/**
	 * ftHgRXgN^B<br/>
	 * <br/>
	 * pbP[Ŵݎg悤ɂB
	 */
	IceryaContainer() {
		
	}
	
	public void addBeanDef(String beanId, String cls) {
		BeanDef beanDef = new BeanDef();
		beanDef.setBeanId(beanId);
		beanDef.setContainer(this);
		this.internal.put(beanId, beanDef);
	}
	
	/**
	 * BeanEntityIuWFNgReiɒǉB
	 * @param entity BeanEntityIuWFNg
	 */
	public void addBeanDef(BeanDef entity) {
		entity.setContainer(this);
		this.internal.put(entity.getBeanId(), entity);
	}
	
	/**
	 * BeanEntityIuWFNgReioB
	 * @param id bean id
	 * @return BeanEntityIuWFNg
	 */
	public BeanDef getBeanDef(String id) {
		return this.internal.get(id);
	}
	
	public Map<String, BeanDef> getAllBeanDef() {
		return this.internal;
	}
	
	/**
	 * Bean擾B
	 * 
	 * @param id Bean ID
	 * @return IuWFNg
	 * @throws ContainerException Bean̐Ɏs
	 */
	public Object getBean(String id) throws ContainerException {
		if(log.isDebugEnabled()) {
			log.debug("---[get bean]---");
		}
		if(id == null || id.equals("")) {
			log.error("Illegal Argument[id=" + id + "].");
			throw new ContainerException("Illegal Argument[id=" + id + "].");
		}
		BeanDef beanDef = this.internal.get(id);
		if(beanDef == null) {
			// CN[hꂽReiT
			int length = this.includeContainer.size();
			
			for(int i = 0; i < length; i++) {
				IceryaContainer container = this.includeContainer.get(i);
				beanDef = container.getBeanDef(id);
				if(beanDef != null) {
					break;
				}
			}
		}
		
		if(beanDef == null) {
			log.error("ID[" + id + "] is not exitst.");
			throw new ContainerException("ID[" + id + "] is not exist.");
		}
		
		Object result = null;
		// LbV헪(LbV̎擾)s
		CacheStrategy cache = beanDef.getCacheStrategy();
		result = cache.getCache();
		
		// 헪s
		if(result == null) {
			// CWFNV헪s
			InjectionStrategy injection = beanDef.getInjectionStrategy();
			if(injection != null) {
				injection.inject(beanDef);
				result = injection.getInjectObject();
			}
			
			// ēxALbV헪(LbV̕ۑ)s
			cache.save(result);

			return result;
		}else {
			return result;
		}
	}
	
	public <T> T getBean(String id, Class<T> cls) throws ContainerException {
		return (T)getBean(id);
	}
	
	/**
	 * p^CYhCWFNVpC^tF[XB
	 * 
	 * @param id
	 * @param args
	 * @return
	 */
	public Object getBean(String id, Object ... args) throws ContainerException {
		if(log.isDebugEnabled()) {
			log.debug("---[get bean]---");
		}
		if(id == null || id.equals("")) {
			log.error("Illegal Argument[id=" + id + "].");
			throw new ContainerException("Illegal Argument[id=" + id + "].");
		}
		BeanDef beanDef = this.internal.get(id);
		if(beanDef == null) {
			// CN[hꂽReiT
			int length = this.includeContainer.size();
			
			for(int i = 0; i < length; i++) {
				IceryaContainer container = this.includeContainer.get(i);
				beanDef = container.getBeanDef(id);
				if(beanDef != null) {
					break;
				}
			}
		}
		
		if(beanDef == null) {
			log.error("ID[" + id + "] is not exitst.");
			throw new ContainerException("ID[" + id + "] is not exist.");
		}
		
		Object result = null;
		// LbV헪(LbV̎擾)s
		CacheStrategy cache = beanDef.getCacheStrategy();
		result = cache.getCache();
		
		if(result == null) {
			// CWFNV헪s
			InjectionStrategy injection = beanDef.getInjectionStrategy();
			
			// ParameterizedInjectionStrategy̏ꍇ͈ݒ肷
			if(injection instanceof ParameterizedInjectionStrategy) {
				((ParameterizedInjectionStrategy)injection).add(args);
			}
			if(injection != null) {
				injection.inject(beanDef);
				result = injection.getInjectObject();
			}

			// ēxALbV헪(LbV̕ۑ)s
			cache.save(result);

			return result;
		}else {
			return result;
		}
	}
	
	public <T> T getBean(String id, Class<T>cls, Object ... args) throws ContainerException {
		return (T)getBean(id, args);
	}
	
	public void injectDependency(String id, Object obj) throws ContainerException {
		if(!this.internal.containsKey(id)) {
			throw new ContainerException("");
		}else {
			BeanDef beanDef = this.internal.get(id);
			InjectionStrategy injection = beanDef.getInjectionStrategy();
			injection.setInjectObject(obj);
			injection.inject(beanDef);
		}
	}
	
	public boolean containsBean(Object key) {
		return this.internal.containsKey(key);
	}
	
	/**
	 * Rei̔jɎs郁\bhB
	 * <br/>
	 * <br/>
	 * DIReiŊǗĂ邷ׂĂdestroyMethodsB
	 * 
	 * @throws Throwable
	 */
	protected void finalize() throws Throwable {
		
		Set<String> keys = this.internal.keySet();
		
		for(Iterator<String> itr = keys.iterator(); itr.hasNext();) {
			String key = itr.next();
			BeanDef beanDef = this.internal.get(key);
			String destroyMethod = beanDef.getDestroyMethod();
			Object obj = beanDef.getCacheStrategy().getCache();
			if(destroyMethod != null && !destroyMethod.equals("")) {
				// destroyMethods
				ReflectionUtil.execute(obj, destroyMethod, null);
			}
		}
		super.finalize();
	}
	
	public void addContainer(IceryaContainer includeContainer) {
		this.includeContainer.add(includeContainer);
	}
	
	public String getMetaDefinition(String key) {
		return this.meta.get(key);
	}
	
	public void addMetaDefinition(String key, String value) {
		this.meta.put(key, value);
	}

	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}
	
	public void weaving() {
		
	}
}
