package org.arefgard.icerya.container.cache.impl;

import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.cache.CacheStrategy;

public class SingletonCacheStrategy extends CacheStrategy {

	private Object singleton = null;
	private Object obj = new Object();
	
	public Object getCache() throws ContainerException {
		synchronized(this.obj) {
			if(singleton != null) {
				return this.singleton;
			}
			return null;
		}
	}

	public void save(Object obj) {
		synchronized(this.obj) {
			this.singleton = obj;
		}
	}

}
