package org.arefgard.icerya.container.injection.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.def.BeanDef;
import org.arefgard.icerya.container.def.PropertyDef;
import org.arefgard.icerya.container.def.ResourceDef;
import org.arefgard.icerya.container.def.ValueResourceDef;

public class ParameterizedInjectionStrategy extends SetterInjectionStrategy {

	public List<Object> args = new java.util.ArrayList<Object>();
	
	@Override
	protected void generate(BeanDef beanDef) throws ContainerException {
		super.generate(beanDef);
	}

	@Override
	protected void injection(BeanDef beanDef) throws ContainerException {
		
		// p^u{n}vŒu
		Map<String, PropertyDef> prop = beanDef.getProperties();
		try {
			if(prop.size() > 0) {
				for (Iterator<String> itr = prop.keySet().iterator(); itr.hasNext();) {
					String key = itr.next();
					String value = null;
					
					PropertyDef propertyDef = prop.get(key);
					ResourceDef resourceDef = propertyDef.getResourceDef();
					if(resourceDef instanceof ValueResourceDef) {
						// ValueResourceDef̏ꍇ͒u\ǂ`FbN
						ValueResourceDef valueDef = (ValueResourceDef)resourceDef;
						
						if(valueDef.getValue() instanceof String) {
							// l̏ꍇ\
							value = (String)valueDef.getValue();
							Pattern pattern = Pattern.compile("{[0-9]*}");
							Matcher matcher = pattern.matcher(value);
							if(matcher.matches()) {
								String ptn = null;
								while(matcher.find()) {
									ptn = matcher.group();
									//matcher.Integer.parseInt(ptn.substring(ptn.indexOf("{"), ptn.lastIndexOf("}")));
								}
								
							}
						}
						
					}
				}
			}
			
			
		}catch(Exception e) {
			
		}
		
		super.injection(beanDef);
	}

	public void add(Object ... args) {
		
		int length = args.length;
		for(int i = 0; i < length; i++) {
			this.args.add(args[i]);
		}
	}


}
