/*************************************************************************************************/
/*!
   	@file		NormFunctionSin.h
	@author 	Fanzo
 	@date 		2008/4/9
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormFunctionSin" class 
**************************************************************************************************/
class NormFunctionSin : 
	virtual public object_base , 
	public INormFunction
{
	query_begin();
	iface_hook( INormFunction , INormFunction_IID )
	query_end( object_base );
	
// variable member
private:
	// f(x) = a * sin( b * ( x + c ) * PI ) + d
	float		m_a , m_b , m_c , m_d;
	
// "INormFunction" interface functions
public:
//=================================================================================================
//!	GetNormalizedValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float cb_call GetNormalizedValue
		(
		float		n		//!< [in] 0.0 - 1.0
		)
{
	// f(x) = a * sin( b * ( x + c ) ) + d
	return m_a * sinf( m_b * ( n + m_c ) * PI_f ) + m_d;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormFunctionSin() : 
		m_a( 0.5f ) , 
		m_b( 1.0f ) , 
		m_c( -0.5f ) , 
		m_d( 0.5f )
		
{
}
//=================================================================================================
//!	set coeff( f(x) = a * sin( b * ( x - c ) ) + d )
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetCoefficient
		(
		float		a , 
		float		b , 
		float		c , 
		float		d
		)
{
	m_a	= a;
	m_b	= b;
	m_c	= c;
	m_d	= d;
}
//=================================================================================================
//!	get coeff( f(x) = a * sin( b * ( x - c ) ) + d )
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call GetCoefficient
		(
		float		*a , 
		float		*b , 
		float		*c , 
		float		*d
		)const
{
	if( a != 0 )	*a	= m_a;
	if( b != 0 )	*b	= m_b;
	if( c != 0 )	*c	= m_c;
	if( d != 0 )	*d	= m_d;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
