/*************************************************************************************************/
/*!
   	@file		TexturePaint.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPaint.h"
#include	"iFace/iTexture.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TexturePaint" class 
**************************************************************************************************/
class TexturePaint : 
	virtual public object_base , 
	public ITexturePaint
{
// query
	query_begin();
	iface_hook( ITexture , ITexture_IID )
	iface_hook( ITexturePaint , ITexturePaint_IID )
	query_end( object_base );
	
// variable member
protected:
	iPaint	m_gen;
	faffine			m_transform;
	faffine			m_uvtod;

	isize			m_size;
	DPI				m_dpi;
	
// "ITexture" interface functions
public:
//=================================================================================================
isize cb_call TextureSize()
{
	return m_size;
}
//=================================================================================================
DPI cb_call TextureDPI()
{
	return m_dpi;
}
//=================================================================================================
ITexture::Type cb_call TextureType()
{
	return ( IPaint::Color == m_gen->PaintType() ) ? ITexture::Color : ITexture::Image;
}
//=================================================================================================
rgba cb_call TextureColor()
{
	return m_gen->PaintColor();
}
//=================================================================================================
pixelformat	cb_call TextureImageFormat()
{
	return m_gen->PaintImageFormat();
}
//=================================================================================================
bool cb_call BeginTextureImage()
{
	if( m_size.width == 0 || m_size.height == 0 )
		return false;
	if( m_gen == false )
		return false;
	m_uvtod		= m_transform * faffine::GetScale( (float)m_size.width , (float)m_size.height );
	return m_gen->BeginPaintImage();
}
//=================================================================================================
void cb_call TextureImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
	m_gen->PaintImage( image , len , m_uvtod.Transform( suv ) , m_uvtod.Transform( tuv ) );
}
//=================================================================================================
void cb_call EndTextureImage()
{
	m_gen->EndPaintImage();
}

// "ITexturePaint" interface functions
public:
//=================================================================================================
void cb_call SetTextureInfo
		(
		const DPI&			dpi , 
		const isize&		size 
		)
{
	m_size	= size;
	m_dpi	= dpi;
}
//=================================================================================================
void cb_call SetPaint
		(
		iPaint	&gen
		)
{
	m_gen	= gen;
}
//=================================================================================================
void cb_call ReleasePaint()
{
	m_gen.release();
}
//=================================================================================================
void cb_call SetTransform
		(
		const faffine&		trans
		)
{
	m_transform	= trans;
}
//=================================================================================================
faffine GetTransform()const
{
	return m_transform;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
