/*************************************************************************************************/
/*!
   	@file		iantialias.h
	@author 	Fanzo
 	@date 		2008/3/23
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		ianitalias_anti_scale_max		16

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum antialias
{
	none_antialias	= 0 , 
	x2_antialias	= 1 , 
	x4_antialias	= 2 , 
	x8_antialias	= 3 , 
	x16_antialias	= 4 , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	anitalias shiftnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int anti_shift
		(
		antialias	anti
		)
{
	return ( int )anti;
}
//=================================================================================================
//!	antialias scale
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int anti_scale
		(
		antialias anti
		)
{
	return ( 1 << anti );
}
//=================================================================================================
//!	antialias mask
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
unsigned int anti_mask
		(
		antialias anti
		)
{
	return ( 1 << anti ) - 1;
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
