/*************************************************************************************************/
/*!
   	@file		iEdgemapCell.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

struct CellEdge
{
	int			m_x;
	int			m_area;
	int			m_dy;
	CellEdge*	m_next;
};
typedef CellEdge*	CellEdgePtr;

struct EdgemapCellInfo
{
	irect			m_area;
	CellEdge**		m_line;	
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IEdgemapCellInfo" interface 
***************************************************************************************************/
cb_guid_define( IEdgemapCellInfo_IID , 0xAF1D9DF7 , 0x99194d98 , 0x809E4F60 , 0x4190BCC6 );
class IEdgemapCellInfo;
typedef icubic::iface_object< IEdgemapCellInfo , IEdgemapCellInfo_IID >		iEdgemapCellInfo;
typedef icubic::iface_reference< IEdgemapCellInfo , IEdgemapCellInfo_IID >	rEdgemapCellInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEdgemapCellInfo
{
public:
//=================================================================================================
//!	get info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call GetEdgemapCellInfo
		(
		EdgemapCellInfo*	info
		) = 0;
};

/**************************************************************************************************
 "IEdgemapCell" interface 
***************************************************************************************************/
cb_guid_define( IEdgemapCell_IID , 0xBE2CBD31 , 0x788743c2 , 0xBC2F4F3F , 0x4AAF7777 );
class IEdgemapCell;
typedef icubic::iface_object< IEdgemapCell , IEdgemapCell_IID >		iEdgemapCell;
typedef icubic::iface_reference< IEdgemapCell , IEdgemapCell_IID >	rEdgemapCell;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEdgemapCell : public IEdgemapCellInfo
{
public:
//=================================================================================================
//!	set outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetOutline
		(
		IOutline*		outline , 
		const faffine&	affine
		) = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

cb_inline
int cell_anti_shift()
{
	return 8;
}
cb_inline
int cell_anti_scale()
{
	return 1 << 8;
}
cb_inline
int cell_anti_mask()
{
	return ( 1 << 8 ) - 1;
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
