/*************************************************************************************************/
/*!
   	@file		iedgemapoutline.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iAntialias.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define


enum PathFillRule
{
	Winding_PathFillRule , 
	EvenOdd_PathFillRule , 
};

enum PathOperator
{
	And_PathOperator , 
	Or_PathOperator , 
	Xor_PathOperator , 
	Sub_PathOperator , 
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

struct OutlineEdge
{
	int				x;
	OutlineEdge*	m_next;
};
struct OutlineScanlineInfo
{
	OutlineEdge*	m_edge;
};
struct EdgemapOutlineInfo
{
	antialias				m_antialias;
	irect					m_area;
	OutlineScanlineInfo*	m_line;	
};
typedef OutlineEdge*	OutlineEdgePtr;

/**************************************************************************************************
 "IEdgemapOutlineInfo" interface 
***************************************************************************************************/
cb_guid_define( IEdgemapOutlineInfo_IID , 0x1004C50A , 0xB77541b4 , 0xBC162AF0 , 0xA920329A );
class IEdgemapOutlineInfo;
typedef icubic::iface_object< IEdgemapOutlineInfo , IEdgemapOutlineInfo_IID >		iEdgemapOutlineInfo;
typedef icubic::iface_reference< IEdgemapOutlineInfo , IEdgemapOutlineInfo_IID >	rEdgemapOutlineInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEdgemapOutlineInfo
{
public:
//=================================================================================================
//!	get info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
const EdgemapOutlineInfo& cb_call GetEdgemapOutlineInfo() = 0;
};

/**************************************************************************************************
 "IEdgemapOutline" interface 
***************************************************************************************************/
cb_guid_define( IEdgemapOutline_IID , 0x8AD86938 , 0xF76B40d3 , 0xA7339557 , 0x34504AAE );
class IEdgemapOutline;
typedef icubic::iface_object< IEdgemapOutline , IEdgemapOutline_IID >	iEdgemapOutline;
typedef icubic::iface_reference< IEdgemapOutline , IEdgemapOutline_IID >	rEdgemapOutline;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEdgemapOutline : public IEdgemapOutlineInfo
{
public:
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Initialize
		(
		antialias		antialias , 
		const irect		&area
		) = 0;
//=================================================================================================
//!	begin_polygon
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BeginOutline() = 0;
//=================================================================================================
//!	set outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetOutline
		(
		IOutlineInfo*	outline , 
		const faffine&	affine
		) = 0;
//=================================================================================================
//!	update_lines. it nessesary to do after set_polygon finished
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call EndOutline
		(
		PathFillRule	rule
		) = 0;
//=================================================================================================
//!	Operate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Operate
		(
		PathOperator			ope , 
		IEdgemapOutlineInfo*	info
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	anitalias shiftnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int outlinedgemap_anti_shift_x()
{
	return ( int )8;
}
//=================================================================================================
//!	antialias scale
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int outlinedgemap_anti_scale_x()
{
	return ( 1 << 8 );
}
//=================================================================================================
//!	antialias mask
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
unsigned int outlinedgemap_anti_mask_x()
{
	return ( 1 << 8 ) - 1;
}


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
