/*************************************************************************************************/
/*!
   	@file		pp_cpp_texture_nearest.h
	@author 	Fanzo
 	@date 		2008/4/20
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"pp_cpp_uv.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace icubic;

//=================================================================================================
// texture nearest m
//=================================================================================================

//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_rgb_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgb( &c , b_color , c );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_rgb_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgb( &c , b_color , c );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_rgb_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgb( &c , b_color , c );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_rgba_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgba( &c , b_color , c );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_rgba_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgba( &c , b_color , c );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_rgba_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgba( &c , b_color , c );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_a_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_a( &c , b_color , c );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_a_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_a( &c , b_color , c );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_repeat_a_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_a( &c , b_color , c );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}

//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_rgb_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgb( &c , b_color , c );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_rgb_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgb( &c , b_color , c );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_rgb_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgb( &c , b_color , c );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_rgba_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgba( &c , b_color , c );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_rgba_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgba( &c , b_color , c );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_rgba_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgba( &c , b_color , c );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_a_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_a( &c , b_color , c );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_a_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_a( &c , b_color , c );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_clamp_a_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_a( &c , b_color , c );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}

//=================================================================================================
// texture nearest m
//=================================================================================================
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_rgb_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgb( &c , b_color , c );
		MulAlpha_rgb( &c , alpha );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_rgb_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgb( &c , b_color , c );
		MulAlpha_rgb( &c , alpha );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_rgb_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgb( &c , b_color , c );
		MulAlpha_rgb( &c , alpha );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_rgba_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgba( &c , b_color , c );
		MulAlpha_rgba( &c , alpha );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_rgba_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgba( &c , b_color , c );
		MulAlpha_rgba( &c , alpha );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_rgba_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgba( &c , b_color , c );
		MulAlpha_rgba( &c , alpha );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_a_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_a( &c , b_color , c );
		MulAlpha_a( &c , alpha );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_a_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_a( &c , b_color , c );
		MulAlpha_a( &c , alpha );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_repeat_a_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_repeat( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_a( &c , b_color , c );
		MulAlpha_a( &c , alpha );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}

//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_rgb_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgb( &c , b_color , c );
		MulAlpha_rgb( &c , alpha );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_rgb_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgb( &c , b_color , c );
		MulAlpha_rgb( &c , alpha );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_rgb_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgb( &c , b_color , c );
		MulAlpha_rgb( &c , alpha );
		rgb_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		
		dest = AddPixelSize_rgb( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_rgba_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_rgba( &c , b_color , c );
		MulAlpha_rgba( &c , alpha );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_rgba_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_rgba( &c , b_color , c );
		MulAlpha_rgba( &c , alpha );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_rgba_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_rgba( &c , b_color , c );
		MulAlpha_rgba( &c , alpha );
		rgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		
		dest = AddPixelSize_rgba( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_a_rgb
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgb();
		
		pp_pixel_calc	c;
		LoadAddr_rgb( &c , ( uint8* )src + s_off );
		rgb_to_a( &c , b_color , c );
		MulAlpha_a( &c , alpha );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_a_rgba
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_rgba();
		
		pp_pixel_calc	c;
		LoadAddr_rgba( &c , ( uint8* )src + s_off );
		rgba_to_a( &c , b_color , c );
		MulAlpha_a( &c , alpha );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m_alpha_clamp_a_a
		(
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha
		)
{
	int32	su	= ( int32 )( ssu * 0x10000 );
	int32	sv	= ( int32 )( ssv * 0x10000 );
	int32	tu	= ( int32 )( ttu * 0x10000 );
	int32	tv	= ( int32 )( ttv * 0x10000 );
	
	int32	du	= ( tu - su ) / len;
	int32	dv	= ( tv - sv ) / len;
	su	+= ( du >> 1 );
	sv	+= ( dv >> 1 );

	int			off;
	for( off = 0; off < len ; off++ )
	{
		int32	u		= su + off * du;
		int32	v		= sv + off * dv;
		Wrap_clamp( &u , &v );
		int32	x		= ( u * src_w ) >> 16;
		int32	y		= ( v * src_h ) >> 16;
		int		s_off	= y * src_pitchbyte + x * PixelSize_a();
		
		pp_pixel_calc	c;
		LoadAddr_a( &c , ( uint8* )src + s_off );
		a_to_a( &c , b_color , c );
		MulAlpha_a( &c , alpha );
		a_to_a( &c , c );
		StoreAddr_a( dest , c );
		
		dest = AddPixelSize_a( dest );
	}	
}


//=================================================================================================
//!	texture nearest
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_texture_nearest_m
		(
		pp_format		destformat , 
		void*			dest , 
		int32			len , 
		float			ssu , 
		float			ssv , 
		float			ttu , 
		float			ttv , 
		pp_format		srcformat , 
		const void*		src , 
		int32			src_pitchbyte , 
		int16			src_w , 
		int16			src_h , 
		const pp_color&	b_color , 
		const pp_alpha&	alpha , 
		pp_wraptype		wrap
		)
{
	typedef void (*func)( void* , int32 , float , float , float , float , const void* , int32 , int16 , int16 , const pp_color& );
	typedef void (*func_a)( void* , int32 , float , float , float , float , const void* , int32 , int16 , int16 , const pp_color& , const pp_alpha& );
	static
	func	funclist[2][4][4] = 
	{
		{
			{
			pp_cpp_texture_nearest_m_repeat_rgb_rgb , 
			pp_cpp_texture_nearest_m_repeat_rgb_rgba , 
			pp_cpp_texture_nearest_m_repeat_rgb_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_repeat_rgba_rgb , 
			pp_cpp_texture_nearest_m_repeat_rgba_rgba , 
			pp_cpp_texture_nearest_m_repeat_rgba_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_repeat_a_rgb , 
			pp_cpp_texture_nearest_m_repeat_a_rgba , 
			pp_cpp_texture_nearest_m_repeat_a_a , 
			} , 
		} , 
		{
			{
			pp_cpp_texture_nearest_m_clamp_rgb_rgb , 
			pp_cpp_texture_nearest_m_clamp_rgb_rgba , 
			pp_cpp_texture_nearest_m_clamp_rgb_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_clamp_rgba_rgb , 
			pp_cpp_texture_nearest_m_clamp_rgba_rgba , 
			pp_cpp_texture_nearest_m_clamp_rgba_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_clamp_a_rgb , 
			pp_cpp_texture_nearest_m_clamp_a_rgba , 
			pp_cpp_texture_nearest_m_clamp_a_a , 
			} , 
		} , 
	};
	static
	func_a	funclist_a[2][4][4] = 
	{
		{
			{
			pp_cpp_texture_nearest_m_alpha_repeat_rgb_rgb , 
			pp_cpp_texture_nearest_m_alpha_repeat_rgb_rgba , 
			pp_cpp_texture_nearest_m_alpha_repeat_rgb_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_alpha_repeat_rgba_rgb , 
			pp_cpp_texture_nearest_m_alpha_repeat_rgba_rgba , 
			pp_cpp_texture_nearest_m_alpha_repeat_rgba_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_alpha_repeat_a_rgb , 
			pp_cpp_texture_nearest_m_alpha_repeat_a_rgba , 
			pp_cpp_texture_nearest_m_alpha_repeat_a_a , 
			} , 
		} , 
		{
			{
			pp_cpp_texture_nearest_m_alpha_clamp_rgb_rgb , 
			pp_cpp_texture_nearest_m_alpha_clamp_rgb_rgba , 
			pp_cpp_texture_nearest_m_alpha_clamp_rgb_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_alpha_clamp_rgba_rgb , 
			pp_cpp_texture_nearest_m_alpha_clamp_rgba_rgba , 
			pp_cpp_texture_nearest_m_alpha_clamp_rgba_a , 
			} , 
			{
			pp_cpp_texture_nearest_m_alpha_clamp_a_rgb , 
			pp_cpp_texture_nearest_m_alpha_clamp_a_rgba , 
			pp_cpp_texture_nearest_m_alpha_clamp_a_a , 
			} , 
		} , 
	};
	if( alpha.a == 256 )
		( funclist[ wrap ][ destformat ][ srcformat ] )( dest , len , ssu , ssv , ttu , ttv , src , src_pitchbyte , src_w , src_h , b_color );
	else
		( funclist_a[ wrap ][ destformat ][ srcformat ] )( dest , len , ssu , ssv , ttu , ttv , src , src_pitchbyte , src_w , src_h , b_color , alpha );
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align

