/*************************************************************************************************/
/*!
   	@file		MemAllocator.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iMemAlloc.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define


///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"MemAlloc" class 
**************************************************************************************************/
class MemAlloc : public IMemAlloc
{
	cb_copy_impossible( MemAlloc);
public:
//=================================================================================================
void* cb_call Allocate
		(
		uint32		size
		)
{
	return malloc( size );
}
//=================================================================================================
void cb_call Deallocate
		(
		void*	p
		)
{
	return free( p );
}
};
/**************************************************************************************************
"MemAllocLump" class 
**************************************************************************************************/
class MemAllocLump : public IMemAllocLump
{
	cb_copy_impossible( MemAllocLump );
	
// member class
private:
	struct Header
	{
		Header*	m_next;
	};
	typedef Header*	HeaderPtr;
// variable member
private:
	Header*			m_first;
	Header*			m_last;
	
// "IMemAllocatorLump" interface functions
public:
//=================================================================================================
void* cb_call Allocate
		(
		uint32		size
		)
{
	int			memsize	= size;
	Header*		p	= ( Header* )malloc( memsize + sizeof( Header ) );
	p->m_next		= 0;
		
	*( m_last == 0 ? &m_first : &m_last->m_next )	= p;
	m_last		= p;

	return (void*)( ( ( unsigned char* )( m_last + 1 ) ) );
}
//=================================================================================================
void cb_call DeallocateAll()
{
	Header*	p = m_first;
	while( p != 0 )
	{
		Header*	n	= p->m_next;
		free( p );
		p	= n;
	}
	m_first		= 0;
	m_last		= 0;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
MemAllocLump() : 
		m_first( 0 ) , 
		m_last( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~MemAllocLump()
{
	cb_assert( m_first == 0 , L"MemAllocStack_inc:memory leak occured." );
	DeallocateAll();
}
};
/**************************************************************************************************
"MemAllocLump_inc" class 
**************************************************************************************************/
class MemAllocLump_inc : public IMemAllocLump
{
	cb_copy_impossible( MemAllocLump_inc );
	
// member class
private:
	struct Header
	{
		uint32	m_mem_size;
		uint32	m_use_size;
		Header*	m_prev;
		Header*	m_next;
	};
	typedef Header*	HeaderPtr;
// variable member
private:
	Header*			m_first;
	Header*			m_last;
	Header*			m_current;
	uint32			m_poolsize;
	
// "IMemAllocatorLump" interface functions
public:
//=================================================================================================
void* cb_call Allocate
		(
		uint32		size
		)
{
	if( m_current == 0 )
		m_current		= m_first;

	while( m_current != 0 && m_current->m_mem_size < ( m_current->m_use_size + size ) )
	{
		if( m_current->m_use_size == 0 )
		{
			Header*	p	= m_current;
			( p->m_prev == 0 ? m_first : p->m_prev->m_next )	= p->m_next;
			( p->m_next == 0 ? m_last : p->m_next->m_prev )		= p->m_prev;
			m_current	= m_current->m_next;
			free( p );
		}
		else
			m_current	= m_current->m_next;
	}
	if( m_current == 0 )
	{
		int			memsize	= max( m_poolsize , size );
		Header*		p	= ( Header* )malloc( memsize + sizeof( Header ) );
		p->m_mem_size	= memsize;
		p->m_use_size	= 0;
		p->m_next		= 0;
		p->m_prev		= m_last;
		
		*( m_last == 0 ? &m_first : &m_last->m_next )	= p;
		m_last		= p;
		m_current	= p;
	}
	void*	p = (void*)( ( ( unsigned char* )( m_current + 1 ) ) + m_current->m_use_size );
	m_current->m_use_size	+= size;
	return	p;
}
//=================================================================================================
void cb_call DeallocateAll()
{
	Header*	p = m_first;
	while( p != 0 )
	{
		p->m_use_size	= 0;
		p	= p->m_next;
	}
	m_current	= 0;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
MemAllocLump_inc
		(
		uint32		poolsize
		) : 
		m_poolsize( poolsize ) , 
		m_first( 0 ) , 
		m_last( 0 ) , 
		m_current( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~MemAllocLump_inc()
{
	cb_assert( m_current == 0 , L"MemAllocLump_inc:memory leak occured." );
	Reset();
}
//=================================================================================================
//!	set allocate pool
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPoolSize
		(
		uint32	poolsize
		)
{
	m_poolsize	= poolsize;
}
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Reset()
{
	Header*	p = m_first;
	while( p != 0 )
	{
		Header*	n	= p->m_next;
		free( p );
		p	= n;
	}
	m_first		= 0;
	m_last		= 0;
	m_current	= 0;
}
};
/**************************************************************************************************
"MemAllocStack_inc" class 
**************************************************************************************************/
class MemAllocStack_inc : public IMemAllocStack
{
	cb_copy_impossible( MemAllocStack_inc );
	
// member class
private:
	struct Header
	{
		uint32	m_mem_size;
		uint32	m_use_size;
		Header*	m_next;
		Header*	m_prev;
	};
	typedef Header*	HeaderPtr;
// variable member
private:
	Header*			m_first;
	Header*			m_last;
	Header*			m_current;
	uint32			m_poolsize;
	
// "IMemAllocStack" interface functions
public:
//=================================================================================================
void* cb_call Allocate
		(
		uint32		size
		)
{
	if( m_current == 0 )
		m_current		= m_first;

	while( m_current != 0 && m_current->m_mem_size < ( m_current->m_use_size + size ) )
		m_current	= m_current->m_next;

	if( m_current == 0 )
	{
		int			memsize	= max( m_poolsize , size );
		Header*		p	= ( Header* )malloc( memsize + sizeof( Header ) );
		p->m_mem_size	= memsize;
		p->m_use_size	= 0;
		p->m_next		= 0;
		p->m_prev		= ( m_last == 0 ) ? 0 : m_last;
				
		*( m_last == 0 ? &m_first : &m_last->m_next )	= p;
		m_last		= p;
		m_current	= p;
	}
	void*	p = (void*)( ( ( unsigned char* )( m_current + 1 ) ) + m_current->m_use_size );
	m_current->m_use_size	+= size;
	return	p;
}
//=================================================================================================
void cb_call Deallocate
		(
		uint32		size
		)
{
	cb_assert( m_current != 0 , L"MemAllocStack_inc:deallocate expand size" );
	while( m_current != 0 && size != 0 )
	{
		if( size <= m_current->m_use_size )
		{
			size	= 0;
			m_current->m_use_size -= size;
		}
		else
		{
			size -= m_current->m_use_size;
			m_current->m_use_size	= 0;
		}
		m_current	= m_current->m_prev;
	}
	cb_assert( size == 0 , L"MemAllocStack_inc:deallocate expand size" );
}
//=================================================================================================
void cb_call DeallocateAll()
{
	Header*	p = m_first;
	while( p != 0 )
	{
		p->m_use_size	= 0;
		p	= p->m_next;
	}
	m_current	= 0;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
MemAllocStack_inc
		(
		uint32		poolsize
		) : 
		m_poolsize( poolsize ) , 
		m_first( 0 ) , 
		m_last( 0 ) , 
		m_current( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~MemAllocStack_inc()
{
	cb_assert( m_current == 0 , L"MemAllocStack_inc:memory leak occured." );
	Reset();
}
//=================================================================================================
//!	set allocate pool
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPoolSize
		(
		uint32	poolsize
		)
{
	m_poolsize	= poolsize;
}
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Reset()
{
	Header*	p = m_first;
	while( p != 0 )
	{
		Header*	n	= p->m_next;
		free( p );
		p	= n;
	}
	m_first		= 0;
	m_last		= 0;
	m_current	= 0;
}
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
