/*************************************************************************************************/
/*!
   	@file		iAudioDevice.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<limits.h>
#include	"iAsio.h"

#pragma pack( push , 8 )		//set align

namespace icubic_audio
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
#ifdef cb_windows
typedef  HWND	wndptr;
#endif
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IAudioDeviceStream" interface 
***************************************************************************************************/
cb_guid_define( IAudioDeviceStream_IID , 0xA4ED72F5 , 0x21474544 , 0xA9195014 , 0x9A38BB91 );
class IAudioDeviceStream;
typedef icubic::iface_object< IAudioDeviceStream , IAudioDeviceStream_IID >		iAudioDeviceStream;
typedef icubic::iface_reference< IAudioDeviceStream , IAudioDeviceStream_IID >	rAudioDeviceStream;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IAudioDeviceStream
{
public:
	class Format
	{
	public:
		uint32			m_channel[2];
		uint32			m_samplespersec;
		uint32			m_buffersamples;
		Format() : 
				m_samplespersec( 0 ) , 
				m_buffersamples( 0 )
		{
			m_channel[0]	= 0;
			m_channel[1]	= 0;
		}
	};
public:
//=================================================================================================
virtual
void cb_call AudioDeviceStream
		(
		int32				ctrlid , 
		const Format&		format , 
		float const*const*	capture , 
		float**				render
		) = 0;
};
/**************************************************************************************************
 "IAudioDevice" interface 
***************************************************************************************************/
cb_guid_define( IAudioDevice_IID , 0xCF15509D , 0xE20A4200 , 0x91B61209 , 0xEAEAD116 );
class IAudioDevice;
typedef icubic::iface_object< IAudioDevice , IAudioDevice_IID >		iAudioDevice;
typedef icubic::iface_reference< IAudioDevice , IAudioDevice_IID >	rAudioDevice;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IAudioDevice
{
public:
	enum State
	{
		Null_State , 
		Stop_State , 
		Play_State , 
	};
	class Format
	{
	public:
		uint32			m_channel[2];
		uint32			m_samplespersec;
		uint32			m_buffersamples;
		Format() : 
				m_samplespersec( 0 ) , 
				m_buffersamples( 0 )
		{
			m_channel[2]	= 0;
			m_channel[2]	= 0;
		}
	};

public:
//=================================================================================================
virtual
bool cb_call SetAudioDeviceStream
		(
		int32					ctrlid , 
		IAudioDeviceStream*		stream
		) = 0;
//=================================================================================================
virtual
wstring cb_call GetDeviceName() = 0;
//=================================================================================================
virtual
void cb_call GetChannelMaximum
		(
		uint32*		in_ch , 
		uint32*		out_ch
		) = 0;
//=================================================================================================
virtual
bool cb_call GetBufferSamplesMaximum
		(
		uint32*		min		= 0 , 
		uint32*		max		= 0 , 
		uint32*		prefer	= 0
		) = 0;
//=================================================================================================
virtual
bool cb_call IsFormatAvailable
		(
		const Format&	fmt
		) = 0;
//=================================================================================================
virtual
bool cb_call Create
		(
		const Format&				fmt , 
		IAudioDeviceStream::Format*	sfmt	= 0
		) = 0;
//=================================================================================================
virtual
bool cb_call GetLatency
		(
		uint32*		input_ms , 
		uint32*		output_ms
		) = 0;
//=================================================================================================
virtual
State cb_call GetState() = 0;
//=================================================================================================
virtual
bool cb_call Play() = 0;
//=================================================================================================
virtual
void cb_call Stop() = 0;
//=================================================================================================
virtual
void cb_call Destroy() = 0;
};
/**************************************************************************************************
 "IAudioDeviceAsio" interface 
***************************************************************************************************/
cb_guid_define( IAudioDeviceAsio_IID , 0xDC68B207 , 0x1E0F448b , 0x964FDD0D , 0xDEA02C02 );
class IAudioDeviceAsio;
typedef icubic::iface_object< IAudioDeviceAsio , IAudioDeviceAsio_IID >		iAudioDeviceAsio;
typedef icubic::iface_reference< IAudioDeviceAsio , IAudioDeviceAsio_IID >	rAudioDeviceAsio;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IAudioDeviceAsio : public IAudioDevice
{
public:
	class Format : public IAudioDevice::Format
	{
	public:
		int32		m_clocksource;
		bool		m_channel_enable[2][256];
		Format() : m_clocksource( -1 )
		{
			int	flow;
			for( flow = 0 ; flow < 2 ; flow++ )
			{
				int	ch;
				for( ch = 0 ; ch < 256 ; ch++ )
					m_channel_enable[flow][ch] = true;
			}
		}
	};
	
public:
//=================================================================================================
virtual
bool cb_call GetChannels
		(
		uint32*		in_channel , 
		uint32*		out_channel
		) = 0;
//=================================================================================================
virtual
bool cb_call GetChannelInfo
		(
		int32				channel , 
		bool				isinput , 
		IAsio::ChannelInfo*	info
		) = 0;
//=================================================================================================
virtual
bool cb_call Create
		(
		const IAudioDeviceAsio::Format&	fmt , 
		IAudioDeviceStream::Format*		sfmt = 0
		) = 0;
//=================================================================================================
virtual
bool cb_call ControlPanel() = 0;
//=================================================================================================
virtual
uint32 cb_call GetClockSourceNum() = 0;
//=================================================================================================
virtual
bool cb_call GetClockSource
		(
		uint32				clock_off , 
		IAsio::ClockSource*	clock
		) = 0;
};

/**************************************************************************************************
 "IAudioDeviceId" interface 
***************************************************************************************************/
cb_guid_define( IAudioDeviceId_IID , 0xA2161F5E , 0x74EA4131 , 0xAAE31CC9 , 0x1FACB08E );
class IAudioDeviceId;
typedef icubic::iface_object< IAudioDeviceId , IAudioDeviceId_IID >		iAudioDeviceId;
typedef icubic::iface_reference< IAudioDeviceId , IAudioDeviceId_IID >	rAudioDeviceId;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IAudioDeviceId
{
public:
//=================================================================================================
virtual
void cb_call SetData
		(
		const void*		data , 
		int32			size
		) = 0;
//=================================================================================================
virtual
const void* cb_call GetDataPtr() = 0;
//=================================================================================================
virtual
int cb_call GetDataSize() = 0;
};
/**************************************************************************************************
 "IEnumAudioDevice" interface 
***************************************************************************************************/
cb_guid_define( IEnumAudioDevice_IID , 0x5E0B2C67 , 0x211F42fe , 0xB2A9C1DB , 0x4ECB5273 );
class IEnumAudioDevice;
typedef icubic::iface_object< IEnumAudioDevice , IEnumAudioDevice_IID >		iEnumAudioDevice;
typedef icubic::iface_reference< IEnumAudioDevice , IEnumAudioDevice_IID >	rEnumAudioDevice;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEnumAudioDevice
{
public:
	enum DeviceType
	{
		Input , 
		Output , 
		InputOutput , 
	};
	class DeviceInfo
	{
	public:
		DeviceType	m_type;
		wstring		m_name;
	};
public:
//=================================================================================================
virtual
void cb_call Enum() = 0;
//=================================================================================================
virtual
bool cb_call GetAudioDeviceId
		(
		int32			devoff , 
		IAudioDeviceId*	id
		) = 0;
//=================================================================================================
virtual
bool cb_call SearchDevice
		(
		int32*			devoff , 
		IAudioDeviceId*	id
		) = 0;
//=================================================================================================
virtual
wstring cb_call GetDriverName() = 0;
//=================================================================================================
virtual
int32 cb_call GetDeviceNum() = 0;
//=================================================================================================
virtual
bool cb_call GetDeviceInfo
		(
		int32		devoff , 
		DeviceInfo*	info
		) = 0;
//=================================================================================================
virtual
iAudioDevice cb_call CreateDevice
		(
		int32		devoff , 
		wndptr		owner
		) = 0;
};
/**************************************************************************************************
 "IEnumAudioDriver" interface 
***************************************************************************************************/
cb_guid_define( IEnumAudioDriver_IID , 0x7AB9692A , 0xF91B46cc , 0xBA0C8E20 , 0x341D8CC8 );
class IEnumAudioDriver;
typedef icubic::iface_object< IEnumAudioDriver , IEnumAudioDriver_IID >		iEnumAudioDriver;
typedef icubic::iface_reference< IEnumAudioDriver , IEnumAudioDriver_IID >	rEnumAudioDriver;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IEnumAudioDriver
{
public:
//=================================================================================================
virtual
void cb_call Enum() = 0;
//=================================================================================================
virtual
bool cb_call SearchDevice
		(
		int32*			drvoff , 
		int32*			devoff , 
		IAudioDeviceId*	id
		) = 0;
//=================================================================================================
virtual
int32 cb_call GetDriverNum() = 0;
//=================================================================================================
virtual
iEnumAudioDevice cb_call GetEnumAudioDevice
		(
		int32		drvid
		) = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
