/*************************************************************************************************/
/*!
   	@file		ArrayAllocator.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
/**************************************************************************************************
"ArrayAllocator" class 
**************************************************************************************************/
template<class t_class>
class ArrayAllocator
{
// member class
template<class t_class>
class Header
{
public:
	Header*		m_next;
	int			m_num;
	t_class*	m_array;
	Header
			(
			int		num
			) : m_num( 0 ) , m_next( 0 )
	{
		m_array	= new t_class[ num ];
		cb_assert( m_array != 0 , L"memory error." );
	}
	~Header()
	{
		if( m_array != 0 )
			delete	[]m_array;
	}
};
typedef	Header<t_class>*	HeaderPtr;
// variable member
private:
	int					m_alloc_num;
	Header<t_class>*	m_first;
	Header<t_class>*	m_last;
	
// private functions
private:
//=================================================================================================
//!	sort
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Sort
		(
		HeaderPtr*		prev
		)
{
	while( ( *prev )->m_next != 0 )
	{
		if( (*prev)->m_num <= (*prev)->m_next->m_num )
			return;
		HeaderPtr	now		= ( *prev );
		HeaderPtr	next	= now->m_next;
		
		now->m_next	= next->m_next;
		next->m_next= now;
		*prev		= next;
	}
	m_last	= (*prev);
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ArrayAllocator() : m_alloc_num( 256 ) , m_first( 0 ) , m_last( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~ArrayAllocator()
{
	Reset();
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Initialize
		(
		int		alloc_num
		)
{
	if( alloc_num == m_alloc_num )
		ResetSeek();
	else
	{
		Reset();
		m_alloc_num	= alloc_num;
	}
}
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Reset()
{
	Header<t_class>*	p = m_first;
	while( p != 0 )
	{
		Header<t_class>*	np = p->m_next;
		delete	p;
		p	= np;
	}
	m_first	= 0;
	m_last	= 0;
}
//=================================================================================================
//!	reset
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ResetSeek()
{
	Header<t_class>*	p = m_first;
	while( p != 0 )
	{
		p->m_num = 0;
		p	= p->m_next;
	}
}
//=================================================================================================
//!	allocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_class* Allocate
		(
		int		num
		)
{
	cb_assert( num <= m_alloc_num , L"Allocate paramter error." );
	
	if( m_first == 0 || m_alloc_num < m_first->m_num + num )
	{
		Header<t_class>*	header	= new Header<t_class>( m_alloc_num );
		header->m_next		= m_first == 0 ? 0 : m_first->m_next;
		m_first	= header;
		m_last	= m_last == 0 ? header : m_last;
	}
	t_class*	p = &m_first->m_array[ m_first->m_num ];
	m_first->m_num += num;
	Sort( &m_first );
	return p;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
