/*************************************************************************************************/
/*!
   	@file		Coord.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PPL" class 
**************************************************************************************************/
class PPL
{
// variable member
private:
	float	m_ppl[2];

// private functions
private:
//=================================================================================================
float Clip
		(
		float	ppl
		)
{
	return ppl;
/*	
	static
	const float	ppl_min	= 0.000001f;
	
	if( 0.0f <= ppl && ppl < ppl_min )
		ppl = ppl_min;
	else if( -ppl_min < ppl && ppl < 0.0f )
		ppl = -ppl_min;
	return ppl;
*/
}
// public functions
public:
//=================================================================================================
PPL()
{
	m_ppl[0]	= 1.0f;
	m_ppl[1]	= 1.0f;
}
//=================================================================================================
PPL
		(
		float	ppl_x , 
		float	ppl_y
		)
{
	SetPPL( ppl_x , ppl_y );
}
//=================================================================================================
bool operator==
		(
		const PPL&	obj
		)const
{
	if( m_ppl[0] != obj.m_ppl[0] )
		return false;
	if( m_ppl[1] != obj.m_ppl[1] )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const PPL&	obj
		)const
{
	if( *this == obj )
		return false;
	return true;
}
//=================================================================================================
float operator[]
		(
		int		n
		)const
{
	if( n <= 0 )
		return m_ppl[0];
	else
		return m_ppl[1];
}
//=================================================================================================
void SetPPL
		(
		float	ppl_x , 
		float	ppl_y
		)
{
	m_ppl[0]	= Clip( ppl_x );
	m_ppl[1]	= Clip( ppl_y );
}
//=================================================================================================
float SetPPL_x
		(
		float	ppl_x
		)
{
	m_ppl[0]	= Clip( ppl_x );
	return m_ppl[0];
}
//=================================================================================================
float SetPPL_y
		(
		float	ppl_y
		)
{
	m_ppl[1]	= Clip( ppl_y );
	return m_ppl[1];
}
//=================================================================================================
float GetPPL_x()const
{
	return m_ppl[0];
}
//=================================================================================================
float GetPPL_y()const
{
	return m_ppl[1];
}
//=================================================================================================
float		GetDir_x()const					{ return m_ppl[0] < 0.0f ? -1.0f : 1.0f; }
float		GetDir_y()const					{ return m_ppl[1] < 0.0f ? -1.0f : 1.0f; }
//=================================================================================================
float		LtoP_x( float	x )const		{ return x * fabs( m_ppl[0] ); }
float		LtoP_y( float	y )const		{ return y * fabs( m_ppl[1] ); }
float		LtoP_w( float	w )const		{ return w * fabs( m_ppl[0] ); }
float		LtoP_h( float	h )const		{ return h * fabs( m_ppl[1] ); }
fvector2	LtoP( const fvector2& p )const	{ return fvector2( LtoP_x( p.x ) , LtoP_y( p.y ) ); }
fsize		LtoP( const fsize& p )const		{ return fsize( LtoP_w( p.width ) , LtoP_h( p.height ) ); }
frect		LtoP( const frect& p )const		{ return frect( LtoP( p.Min() ) , LtoP( p.Max() ) ).Normalize(); }
faffine		LtoP_xy()const					{ return faffine::GetScale( fabs( m_ppl[0] ) , fabs( m_ppl[1] ) ); }
faffine		LtoP_wh()const					{ return faffine::GetScale( fabs( m_ppl[0] ) , fabs( m_ppl[1] ) ); }
//=================================================================================================
float		LtoD_x( float	x )const		{ return x * m_ppl[0]; }
float		LtoD_y( float	y )const		{ return y * m_ppl[1]; }
float		LtoD_w( float	w )const		{ return w * fabs( m_ppl[0] ); }
float		LtoD_h( float	h )const		{ return h * fabs( m_ppl[1] ); }
fvector2	LtoD( const fvector2& p )const	{ return fvector2( LtoD_x( p.x ) , LtoD_y( p.y ) ); }
fsize		LtoD( const fsize& p )const		{ return fsize( LtoD_w( p.width ) , LtoD_h( p.height ) ); }
frect		LtoD( const frect& p )const		{ return frect( LtoD( p.Min() ) , LtoD( p.Max() ) ).Normalize(); }
faffine		LtoD_xy()const					{ return faffine::GetScale( m_ppl[0] , m_ppl[1] ); }
faffine		LtoD_wh()const					{ return faffine::GetScale( fabs( m_ppl[0] ) , fabs( m_ppl[1] ) ); }
//=================================================================================================
float		PtoL_x( float	x )const		{ return x / fabs( m_ppl[0] ); }
float		PtoL_y( float	y )const		{ return y / fabs( m_ppl[1] ); }
float		PtoL_w( float	w )const		{ return w / fabs( m_ppl[0] ); }
float		PtoL_h( float	h )const		{ return h / fabs( m_ppl[1] ); }
fvector2	PtoL( const fvector2& p )const	{ return fvector2( PtoL_x( p.x ) , PtoL_y( p.y ) ); }
fsize		PtoL( const fsize& p )const		{ return fsize( PtoL_w( p.width ) , PtoL_h( p.height ) ); }
frect		PtoL( const frect& p )const		{ return frect( PtoL( p.Min() ) , PtoL( p.Max() ) ).Normalize(); }
faffine		PtoL_xy()const					{ return faffine::GetScale( fabs( 1.0f/m_ppl[0] ) , fabs( 1.0f/m_ppl[1] ) ); }
faffine		PtoL_wh()const					{ return faffine::GetScale( fabs( 1.0f/m_ppl[0] ) , fabs( 1.0f/m_ppl[1] ) ); }
//=================================================================================================
float		PtoD_x( float	x )const		{ return m_ppl[0] < 0.0f ? -x : x; }
float		PtoD_y( float	y )const		{ return m_ppl[1] < 0.0f ? -y : y; }
float		PtoD_w( float	w )const		{ return w; }
float		PtoD_h( float	h )const		{ return h; }
fvector2	PtoD( const fvector2& p )const	{ return fvector2( PtoD_x( p.x ) , PtoD_y( p.y ) ); }
fsize		PtoD( const fsize& p )const		{ return fsize( PtoD_w( p.width ) , PtoD_h( p.height ) ); }
frect		PtoD( const frect& p )const		{ return frect( PtoD( p.Min() ) , PtoD( p.Max() ) ).Normalize(); }
faffine		PtoD_xy()const					{ return faffine::GetScale( m_ppl[0] < 0.0f ? -1.0f : 1.0f , m_ppl[1] < 0.0f ? -1.0f : 1.0f ); }
faffine		PtoD_wh()const					{ return faffine::GetScale( 1.0f , 1.0f ); }
//=================================================================================================
float		DtoP_x( float	x )const		{ return m_ppl[0] < 0.0f ? -x : x; }
float		DtoP_y( float	y )const		{ return m_ppl[1] < 0.0f ? -y : y; }
float		DtoP_w( float	w )const		{ return w; }
float		DtoP_h( float	h )const		{ return h; }
fvector2	DtoP( const fvector2& p )const	{ return fvector2( DtoP_x( p.x ) , DtoP_y( p.y ) ); }
fsize		DtoP( const fsize& p )const		{ return fsize( DtoP_w( p.width ) , DtoP_h( p.height ) ); }
frect		DtoP( const frect& p )const		{ return frect( DtoP( p.Min() ) , DtoP( p.Max() ) ).Normalize(); }
faffine		DtoP_xy()const					{ return faffine::GetScale( m_ppl[0] < 0.0f ? -1.0f : 1.0f , m_ppl[1] < 0.0f ? -1.0f : 1.0f ); }
faffine		DtoP_wh()const					{ return faffine::GetScale( 1.0f , 1.0f ); }
//=================================================================================================
float		DtoL_x( float	x )const		{ return x / m_ppl[0]; }
float		DtoL_y( float	y )const		{ return y / m_ppl[1]; }
float		DtoL_w( float	w )const		{ return w / fabs( m_ppl[0] ); }
float		DtoL_h( float	h )const		{ return h / fabs( m_ppl[1] ); }
fvector2	DtoL( const fvector2& p )const	{ return fvector2( DtoL_x( p.x ) , DtoL_y( p.y ) ); }
fsize		DtoL( const fsize& p )const		{ return fsize( DtoL_w( p.width ) , DtoL_h( p.height ) ); }
frect		DtoL( const frect& p )const		{ return frect( DtoL( p.Min() ) , DtoL( p.Max() ) ).Normalize(); }
faffine		DtoL_xy()const					{ return faffine::GetScale( 1.0f/m_ppl[0] , 1.0f/m_ppl[1] ); }
faffine		DtoL_wh()const					{ return faffine::GetScale( fabs( 1.0f/m_ppl[0] ) , fabs( 1.0f/m_ppl[1] ) ); }
};
/**************************************************************************************************
"Coord_l" class 
**************************************************************************************************/
class Coord_l
{
// variable member
private:
	DPI			m_dpi;
	PPL			m_ppl;
	
// public functions
public:
//=================================================================================================
Coord_l()
{
}
//=================================================================================================
Coord_l
		(
		const Coord_l&	obj
		)
{
	m_dpi		= obj.m_dpi;
	m_ppl		= obj.m_ppl;
}
//=================================================================================================
Coord_l
		(
		const DPI&	dpi , 
		const PPL&	ppl
		) : m_dpi( dpi ) , m_ppl( ppl )
{
}
//=================================================================================================
Coord_l& operator=
		(
		const Coord_l& obj
		)
{
	m_dpi		= obj.m_dpi;
	m_ppl		= obj.m_ppl;
	return *this;
}
//=================================================================================================
bool operator==
		(
		const Coord_l&	obj
		)const
{
	if( m_dpi != obj.m_dpi )
		return false;
	if( m_ppl != obj.m_ppl )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const Coord_l&	obj
		)const
{
	if( *this == obj )
		return false;
	return true;
}
//=================================================================================================
const DPI& GetDPI()const
{
	return m_dpi;
}
//=================================================================================================
void SetDPI
		(
		const DPI&	dpi
		)
{
	m_dpi	= dpi;
}
//=================================================================================================
const PPL& GetPPL()const
{
	return m_ppl;
}
//=================================================================================================
void SetPPL
		(
		const PPL&	ppl
		)
{
	m_ppl	= ppl;
}
//=================================================================================================
float		GetDir_x()const					{ return m_ppl.GetDir_x(); }
float		GetDir_y()const					{ return m_ppl.GetDir_y(); }
//=================================================================================================
float		LtoP_x( float x )const			{ return m_ppl.LtoP_x( x ); }
float		LtoP_y( float y )const			{ return m_ppl.LtoP_y( y ); }
float		LtoP_w( float w )const			{ return m_ppl.LtoP_w( w ); }
float		LtoP_h( float h )const			{ return m_ppl.LtoP_h( h ); }
fvector2	LtoP( const fvector2& p )const	{ return m_ppl.LtoP( p );	}
fsize		LtoP( const fsize& p )const		{ return m_ppl.LtoP( p );	}
frect		LtoP( const frect& p )const		{ return m_ppl.LtoP( p );	}
faffine		LtoP_xy()const					{ return m_ppl.LtoP_xy(); }
faffine		LtoP_wh()const					{ return m_ppl.LtoP_wh(); }
//=================================================================================================
float		LtoI_x( float x )const			{ return m_dpi.DtoI_x( LtoP_x( x ) ); }
float		LtoI_y( float y )const			{ return m_dpi.DtoI_y( LtoP_y( y ) ); }
float		LtoI_w( float w	)const			{ return m_dpi.DtoI_x( LtoP_w( w ) ); }
float		LtoI_h( float h	)const			{ return m_dpi.DtoI_y( LtoP_h( h ) ); }
fvector2	LtoI( const fvector2& p )const	{ return m_dpi.DtoI( LtoP( p ) ); }
fsize		LtoI( const fsize& p )const		{ return m_dpi.DtoI( LtoP( p ) ); }
frect		LtoI( const frect& p )const		{ return m_dpi.DtoI( LtoP( p ) ); }
faffine		LtoI_xy()const					{ return m_dpi.DtoI_xy() * LtoP_xy(); }
faffine		LtoI_wh()const					{ return m_dpi.DtoI_xy() * LtoP_wh(); }
//=================================================================================================
float		LtoD_x( float x )const			{ return m_ppl.LtoD_x( x ); }
float		LtoD_y( float y )const			{ return m_ppl.LtoD_y( y ); }
float		LtoD_w( float w	)const			{ return m_ppl.LtoD_w( w ); }
float		LtoD_h( float h	)const			{ return m_ppl.LtoD_h( h ); }
fvector2	LtoD( const fvector2& p )const	{ return m_ppl.LtoD( p ); }
fsize		LtoD( const fsize& p )const		{ return m_ppl.LtoD( p ); }
frect		LtoD( const frect& p )const		{ return m_ppl.LtoD( p ); }
faffine		LtoD_xy()const					{ return m_ppl.LtoD_xy(); }
faffine		LtoD_wh()const					{ return m_ppl.LtoD_wh(); }
//=================================================================================================
float		PtoL_x( float x )const			{ return m_ppl.PtoL_x( x ); }
float		PtoL_y( float y )const			{ return m_ppl.PtoL_y( y ); }
float		PtoL_w( float w )const			{ return m_ppl.PtoL_w( w ); }
float		PtoL_h( float h )const			{ return m_ppl.PtoL_h( h ); }
fvector2	PtoL( const fvector2& p )const	{ return m_ppl.PtoL( p ); }
fsize		PtoL( const fsize& p )const		{ return m_ppl.PtoL( p ); }
frect		PtoL( const frect& p )const		{ return m_ppl.PtoL( p ); }
faffine		PtoL_xy()const					{ return m_ppl.PtoL_xy(); }
faffine		PtoL_wh()const					{ return m_ppl.PtoL_wh(); }
//=================================================================================================
float		PtoI_x( float x )const			{ return m_dpi.DtoI_x( x ); }
float		PtoI_y( float y )const			{ return m_dpi.DtoI_y( y ); }
float		PtoI_w( float w )const			{ return m_dpi.DtoI_x( w ); }
float		PtoI_h( float h )const			{ return m_dpi.DtoI_y( h ); }
fvector2	PtoI( const fvector2& p )const	{ return m_dpi.DtoI( p ); }
fsize		PtoI( const fsize& p )const		{ return m_dpi.DtoI( p ); }
frect		PtoI( const frect& p )const		{ return m_dpi.DtoI( p ); }
faffine		PtoI_xy()const					{ return m_dpi.DtoI_xy(); }
faffine		PtoI_wh()const					{ return m_dpi.DtoI_xy(); }
//=================================================================================================
float		PtoD_x( float x )const			{ return m_ppl.PtoD_x( x ); }
float		PtoD_y( float y )const			{ return m_ppl.PtoD_y( y ); }
float		PtoD_w( float w )const			{ return m_ppl.PtoD_w( w ); }
float		PtoD_h( float h )const			{ return m_ppl.PtoD_h( h ); }
fvector2	PtoD( const fvector2& p )const	{ return m_ppl.PtoD( p ); }
fsize		PtoD( const fsize& p )const		{ return m_ppl.PtoD( p ); }
frect		PtoD( const frect& p )const		{ return m_ppl.PtoD( p ); }
faffine		PtoD_xy()const					{ return m_ppl.PtoD_xy(); }
faffine		PtoD_wh()const					{ return m_ppl.PtoD_wh(); }
//=================================================================================================
float		ItoL_x( float x )const			{ return m_ppl.PtoL_x( ItoP_x( x ) ); }
float		ItoL_y( float y )const			{ return m_ppl.PtoL_y( ItoP_y( y ) ); }
float		ItoL_w( float w )const			{ return m_ppl.PtoL_w( ItoP_w( w ) ); }
float		ItoL_h( float h )const			{ return m_ppl.PtoL_h( ItoP_h( h ) ); }
fvector2	ItoL( const fvector2& p )const	{ return m_ppl.PtoL( ItoP( p ) ); }
fsize		ItoL( const fsize& p )const		{ return m_ppl.PtoL( ItoP( p ) ); }
frect		ItoL( const frect& p )const		{ return m_ppl.PtoL( ItoP( p ) ); }
faffine		ItoL_xy()const					{ return m_ppl.PtoL_xy() * ItoP_xy(); }
faffine		ItoL_wh()const					{ return m_ppl.PtoL_wh() * ItoP_wh(); }
//=================================================================================================
float		ItoP_x( float x )const			{ return m_dpi.ItoD_x( x ); }
float		ItoP_y( float y )const			{ return m_dpi.ItoD_y( y ); }
float		ItoP_w( float w )const			{ return m_dpi.ItoD_x( w ); }
float		ItoP_h( float h )const			{ return m_dpi.ItoD_y( h ); }
fvector2	ItoP( const fvector2& p )const	{ return m_dpi.ItoD( p ); }
fsize		ItoP( const fsize& p )const		{ return m_dpi.ItoD( p ); }
frect		ItoP( const frect& p )const		{ return m_dpi.ItoD( p ); }
faffine		ItoP_xy()const					{ return m_dpi.ItoD_xy(); }
faffine		ItoP_wh()const					{ return m_dpi.ItoD_xy(); }
//=================================================================================================
float		ItoD_x( float x )const			{ return m_ppl.PtoD_x( ItoP_x( x ) ); }
float		ItoD_y( float y )const			{ return m_ppl.PtoD_y( ItoP_y( y ) ); }
float		ItoD_w( float w )const			{ return m_ppl.PtoD_w( ItoP_w( w ) ); }
float		ItoD_h( float h )const			{ return m_ppl.PtoD_h( ItoP_h( h ) ); }
fvector2	ItoD( const fvector2& p )const	{ return m_ppl.PtoD( ItoP( p ) ); }
fsize		ItoD( const fsize& p )const		{ return m_ppl.PtoD( ItoP( p ) ); }
frect		ItoD( const frect& p )const		{ return m_ppl.PtoD( ItoP( p ) ); }
faffine		ItoD_xy()const					{ return m_ppl.PtoD_xy() * ItoP_xy(); }
faffine		ItoD_wh()const					{ return m_ppl.PtoD_wh() * ItoP_wh(); }
//=================================================================================================
float		DtoL_x( float x )const			{ return PtoL_x( DtoP_x( x ) ); }
float		DtoL_y( float y )const			{ return PtoL_y( DtoP_y( y ) ); }
float		DtoL_w( float w )const			{ return PtoL_w( DtoP_w( w ) ); }
float		DtoL_h( float h )const			{ return PtoL_h( DtoP_h( h ) ); }
fvector2	DtoL( const fvector2& p )const	{ return PtoL( DtoP( p ) ); }
fsize		DtoL( const fsize& p )const		{ return PtoL( DtoP( p ) ); }
frect		DtoL( const frect& p )const		{ return PtoL( DtoP( p ) ); }
faffine		DtoL_xy()const					{ return PtoL_xy() * DtoP_xy(); }
faffine		DtoL_wh()const					{ return PtoL_wh() * DtoP_wh(); }
//=================================================================================================
float		DtoP_x( float x )const			{ return m_ppl.DtoP_x( x ); }
float		DtoP_y( float y )const			{ return m_ppl.DtoP_y( y ); }
float		DtoP_w( float w )const			{ return m_ppl.DtoP_w( w ); }
float		DtoP_h( float h )const			{ return m_ppl.DtoP_h( h ); }
fvector2	DtoP( const fvector2& p )const	{ return m_ppl.DtoP( p ); }
fsize		DtoP( const fsize& p )const		{ return m_ppl.DtoP( p ); }
frect		DtoP( const frect& p )const		{ return m_ppl.DtoP( p ); }
faffine		DtoP_xy()const					{ return m_ppl.DtoP_xy(); }
faffine		DtoP_wh()const					{ return m_ppl.DtoP_wh(); }
//=================================================================================================
float		DtoI_x( float x )const			{ return m_dpi.DtoI_x( DtoP_x( x ) ); }
float		DtoI_y( float y )const			{ return m_dpi.DtoI_y( DtoP_y( y ) ); }
float		DtoI_w( float w )const			{ return m_dpi.DtoI_x( DtoP_w( w ) ); }
float		DtoI_h( float h )const			{ return m_dpi.DtoI_y( DtoP_h( h ) ); }
fvector2	DtoI( const fvector2& p )const	{ return m_dpi.DtoI( DtoP( p ) ); }
fsize		DtoI( const fsize& p )const		{ return m_dpi.DtoI( DtoP( p ) ); }
frect		DtoI( const frect& p )const		{ return m_dpi.DtoI( DtoP( p ) ); }
faffine		DtoI_xy()const					{ return m_dpi.DtoI_xy() * DtoP_xy(); }
faffine		DtoI_wh()const					{ return m_dpi.DtoI_xy() * DtoP_wh(); }
};
/**************************************************************************************************
"Coord_ld" class 
**************************************************************************************************/
class Coord_ld
{
// variable member
private:
	faffine		m_DtoPD;
	faffine		m_PDtoD;
	Coord_l		m_logical;
	
// public functions
public:
//=================================================================================================
Coord_ld()
{
}
//=================================================================================================
Coord_ld
		(
		const Coord_ld&	obj
		)
{
	m_PDtoD		= obj.m_PDtoD;
	m_DtoPD		= obj.m_DtoPD;
	m_logical	= obj.m_logical;
}
//=================================================================================================
Coord_ld
		(
		const faffine&		d_to_pd , 
		const Coord_l&		logical
		) : m_DtoPD( d_to_pd ) , m_PDtoD( d_to_pd.Inverse() ) , m_logical( logical )
{
}
//=================================================================================================
Coord_ld& operator=
		(
		const Coord_ld& obj
		)
{
	m_PDtoD		= obj.m_PDtoD;
	m_DtoPD		= obj.m_DtoPD;
	m_logical	= obj.m_logical;
	return *this;
}
//=================================================================================================
bool operator==
		(
		const Coord_ld&	obj
		)const
{
	if( m_DtoPD != obj.m_DtoPD )
		return false;
	if( m_logical != obj.m_logical )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const Coord_ld&	obj
		)const
{
	if( *this == obj )
		return false;
	return true;
}
//=================================================================================================
faffine GetDtoPD()const
{
	return m_DtoPD;
}
//=================================================================================================
void SetDtoPD
		(
		const faffine&	trans
		)
{
	m_DtoPD	= trans;
	m_PDtoD	= trans.Inverse();
}
//=================================================================================================
const Coord_l& GetLogical()const
{
	return m_logical;
}
//=================================================================================================
void SetLogical
		(
		const Coord_l&	logical
		)
{
	m_logical	= logical;
}
//=================================================================================================
Coord_ld Transform
		(
		const Coord_ld&		base
		)const
{
	return Coord_ld
			(
			base.GetDtoPD() * m_DtoPD , 
			m_logical
			);
}
//=================================================================================================
fvector2	LtoPD( const fvector2& p )const	{ return m_DtoPD.Transform( m_logical.LtoD( p ) ); }
faffine		LtoPD()const					{ return m_DtoPD * m_logical.LtoD_xy(); }
//=================================================================================================
fvector2	PtoPD( const fvector2& p )const	{ return m_DtoPD.Transform( m_logical.PtoD( p ) ); }
faffine		PtoPD()const					{ return m_DtoPD * m_logical.PtoD_xy(); }
//=================================================================================================
fvector2	ItoPD( const fvector2& p )const	{ return m_DtoPD.Transform( m_logical.ItoD( p ) ); }
faffine		ItoPD()const					{ return m_DtoPD * m_logical.ItoD_xy(); }
//=================================================================================================
fvector2	DtoPD( const fvector2& p )const	{ return m_DtoPD.Transform( p ); }
faffine		DtoPD()const					{ return m_DtoPD; }
//=================================================================================================
fvector2	PDtoL( const fvector2& p )const	{ return m_logical.DtoL( m_PDtoD.Transform( p ) ); }
faffine		PDtoL()const					{ return m_logical.DtoL_xy() * m_PDtoD; }
//=================================================================================================
fvector2	PDtoP( const fvector2& p )const	{ return m_logical.DtoP( m_PDtoD.Transform( p ) ); }
faffine		PDtoP()const					{ return m_logical.DtoP_xy() * m_PDtoD; }
//=================================================================================================
fvector2	PDtoI( const fvector2& p )const	{ return m_logical.DtoI( m_PDtoD.Transform( p ) ); }
faffine		PDtoI()const					{ return m_logical.DtoI_xy() * m_PDtoD; }
//=================================================================================================
fvector2	PDtoD( const fvector2& p )const	{ return m_PDtoD.Transform( p ); }
faffine		PDtoD()const					{ return m_PDtoD; }
};

/**************************************************************************************************
"Coord_view" class 
**************************************************************************************************/
class Coord_view
{
public:
	enum AspectRatio
	{
		Adjust , 
		AspectMin , 
		AspectMax
	};
	enum Align
	{
		MinAlign , 
		MidAlign , 
		MaxAlign , 
	};
// variable member
private:
	faffine		m_vtod;
	faffine		m_dtov;
	DPI			m_dpi;
	frect		m_view;
	
// private functions
private:
//=================================================================================================
frect GetAspectView
		(
		AspectRatio		aspect , 
		Align			horz , 
		Align			vert , 
		const frect&	frame , 
		const fsize&	view
		)const
{
	frect		r;
	if( aspect == Adjust )
		r	= frame;
	else
	{
		float	s[2]	= { frame.Width() / view.width , frame.Height() / view.height };
		fsize	ts;
		if( aspect == AspectMin )
		{
			ts.width	= s[0] <= s[1] ? frame.Width() : view.width * s[1];
			ts.height	= s[0] >= s[1] ? frame.Height() : view.height * s[0];
		}
		else
		{
			ts.width	= s[0] >= s[1] ? frame.Width() : view.width * s[1];
			ts.height	= s[0] <= s[1] ? frame.Height() : view.height * s[0];
		}
//		fsize	ts		= ( aspect == AspectMin ) ? ( view * min( s[0],s[1]) ) : ( view * max( s[0],s[1] ) );
		if( horz == MinAlign )
		{
			r.xmin = frame.xmin; 
			r.xmax = frame.xmin + ts.width; 
		}
		else if( horz == MidAlign )
		{
			r.xmin = frame.xmin + ( frame.Width() - ts.width ) / 2.0f; 
			r.xmax = frame.xmin + ( frame.Width() + ts.width ) / 2.0f;
		}
		else
		{
			r.xmin = frame.xmax - ts.width;
			r.xmax = frame.xmax; 
		}
		if( vert == MinAlign )
		{
			r.ymin = frame.ymin; 
			r.ymax = frame.ymin + ts.height; 
		}
		else if( vert == MidAlign )
		{
			r.ymin = frame.ymin + ( frame.Height() - ts.height ) / 2.0f; 
			r.ymax = frame.ymin + ( frame.Height() + ts.height ) / 2.0f;
		}
		else
		{
			r.ymin = frame.ymax - ts.height;
			r.ymax = frame.ymax; 
		}
	}
	return r;
}
// public functions
public:
//=================================================================================================
Coord_view() : m_view( 0.0f , 0.0f , 100.0f , 100.0f )
{
}
//=================================================================================================
Coord_view
		(
		const faffine&	vtod , 
		const DPI&		dpi , 
		const frect&	view
		) : m_dtov( vtod.Inverse() ) , m_dpi( dpi ) , m_view( view ) , m_vtod( vtod )
{
}
//=================================================================================================
void Initialize
		(
		const faffine&	vtod , 
		const DPI&		dpi , 
		const frect&	view
		)
{
	 m_vtod	= vtod;
	 m_dtov	= vtod.Inverse();
	 m_dpi	= dpi;
	 m_view	= view;
}
//=================================================================================================
const faffine& GetVtoD()const
{
	return m_vtod;
}
//=================================================================================================
const DPI& GetDPI()const
{
	return m_dpi;
}
//=================================================================================================
const frect& GetView()const
{
	return m_view;
}
//=================================================================================================
void SetView
		(
		const frect&	view
		)
{
	m_view	= view.Normalize();
}
//=================================================================================================
void SetView
		(
		const faffine&	vtod , 
		const DPI&		dpi , 
		const frect&	view
		)
{
	m_dpi	= dpi;
	m_vtod	= m_vtod * vtod;
	m_dtov	= m_vtod.Inverse();
	m_view	= view.Normalize();
}
//=================================================================================================
void SetView
		(
		AspectRatio		aspect , 
		Align			horz , 
		Align			vert , 
		const DPI&		dpi , 
		const frect&	view
		)
{
	frect	sv	= view.Normalize();
	frect	tv	= GetAspectView( aspect , horz , vert , m_view , sv.Size() );
	m_dpi	= dpi;
	m_vtod	= m_vtod
			* faffine::GetMove( tv.Min() )
			* faffine::GetScale( tv.Width()/sv.Width() , tv.Height()/sv.Height() )
			* faffine::GetMove( -sv.Min() );
	m_dtov	= m_vtod.Inverse();
	m_view	= sv;
}
//=================================================================================================
float		PtoI_x( float x )const			{ return m_dpi.DtoI_x( x ); }
float		PtoI_y( float y )const			{ return m_dpi.DtoI_y( y ); }
float		PtoI_w( float w )const			{ return m_dpi.DtoI_x( w ); }
float		PtoI_h( float h )const			{ return m_dpi.DtoI_y( h ); }
fvector2	PtoI( const fvector2& p )const	{ return m_dpi.DtoI( p ); }
fsize		PtoI( const fsize& p )const		{ return m_dpi.DtoI( p ); }
frect		PtoI( const frect& p )const		{ return m_dpi.DtoI( p ); }
faffine		PtoI()const						{ return m_dpi.DtoI_xy(); }
//=================================================================================================
fvector2	PtoD( const fvector2& p )const	{ return m_vtod.Transform( p ); }
faffine		PtoD()const						{ return m_vtod; }
//=================================================================================================
float		ItoP_x( float x )const			{ return m_dpi.ItoD_x( x ); }
float		ItoP_y( float y )const			{ return m_dpi.ItoD_y( y ); }
float		ItoP_w( float w )const			{ return m_dpi.ItoD_x( w ); }
float		ItoP_h( float h )const			{ return m_dpi.ItoD_y( h ); }
fvector2	ItoP( const fvector2& p )const	{ return m_dpi.ItoD( p ); }
fsize		ItoP( const fsize& p )const		{ return m_dpi.ItoD( p ); }
frect		ItoP( const frect& p )const		{ return m_dpi.ItoD( p ); }
faffine		ItoP()const						{ return m_dpi.ItoD_xy(); }
//=================================================================================================
fvector2	ItoD( const fvector2& p )const	{ return PtoD( ItoP(p) ); }
faffine		ItoD()const						{ return PtoD() * ItoP(); }
//=================================================================================================
fvector2	DtoP( const fvector2& p )const	{ return m_dtov.Transform( p ); }
faffine		DtoP()const						{ return m_dtov; }
//=================================================================================================
fvector2	DtoI( const fvector2& p )const	{ return PtoI(DtoP(p)); }
faffine		DtoI()const						{ return PtoI() * DtoP(); }
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
