/*************************************************************************************************/
/*!
   	@file		outline.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutline.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"Outline" class 
**************************************************************************************************/
class Outline_bs : 
	public IOutline
{
private:
	class ClipMin
	{
	public:
		template<class t_type>
		static
		bool Inside
				(
				const t_type&	v , 
				const t_type&	limit
				)
		{
			return ( v >= limit );
		}
	};
	class ClipMax
	{
	public:
		template<class t_type>
		static
		bool Inside
				(
				const t_type&	v , 
				const t_type&	limit
				)
		{
			return ( v <= limit );
		}
	};
// variable member
private:
	IMemAllocLump*	m_allocator;

	bool			m_bound_exist;
	frect			m_boundbox;
	OutlineSeg*		m_first;
	OutlineSeg*		m_last;

// private functions
private:
//=================================================================================================
//!	create OutlineSeg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineSeg* CreateOutlineSeg()
{
	return ( OutlineSeg* )m_allocator->Allocate( sizeof( OutlineSeg ) );
}
//=================================================================================================
//!	create OutlineNode
//!	@retval			---
//-------------------------------------------------------------------------------------------------
OutlineNode* CreateOutlineNode()
{
	return ( OutlineNode* )m_allocator->Allocate( sizeof( OutlineNode ) );
}
//=================================================================================================
//!	UpdateBoundBox
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateBoundBox
		(
		const fvector2&		pos
		)
{
	if( m_bound_exist == false )
	{
		m_boundbox.xmin	= pos.x;
		m_boundbox.ymin	= pos.y;
		m_boundbox.xmax	= pos.x;
		m_boundbox.ymax	= pos.y;
		m_bound_exist	= true;
	}
	else
	{
		m_boundbox.xmin	= m_boundbox.xmin < pos.x ? m_boundbox.xmin : pos.x;
		m_boundbox.ymin	= m_boundbox.ymin < pos.y ? m_boundbox.ymin : pos.y;
		m_boundbox.xmax	= m_boundbox.xmax > pos.x ? m_boundbox.xmax : pos.x;
		m_boundbox.ymax	= m_boundbox.ymax > pos.y ? m_boundbox.ymax : pos.y;
	}
}
//=================================================================================================
//!	clip
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_compare , int xy>
void Clip
		(
		OutlineNodePtr*	prev , 
		const faffine&	trans , 
		const faffine&	trans_inv , 
		float			limit
		)
{
	if( *prev == 0 )
		return;

	OutlineNodePtr*	src		= prev;
	fvector2		sp		= trans_inv.Transform( fvector2( (*src)->x , (*src)->y ) );
	bool			in_f[2]	= { t_compare::Inside( sp.m[xy] , limit ) , false };

	while( (*src) != 0 )
	{
		fvector2		tp;
		{
			OutlineNodePtr*	tgt = ((*src)->m_next == 0) ? prev : &((*src)->m_next);
			tp	= trans_inv.Transform( fvector2( (*tgt)->x , (*tgt)->y ) );
		}
		in_f[1]	= t_compare::Inside( tp.m[xy] , limit );

		if( in_f[0] == true && in_f[1] == true )
		{
			UpdateBoundBox( fvector2( (*src)->x , (*src)->y ) );
			src		= &((*src)->m_next);
		}
		else if( in_f[0] == false && in_f[1] == false )
		{
			*src	= (*src)->m_next;
		}
		else if( in_f[0] == true && in_f[1] == false )
		{
			float		r	= ( limit - sp.m[xy] ) / ( tp.m[xy] - sp.m[xy] );
			fvector2	c	= trans.Transform(( tp - sp ) * r + sp);

			UpdateBoundBox( fvector2( (*src)->x , (*src)->y ) );
			UpdateBoundBox( c );
			src		= InsertNode( &((*src)->m_next) , c );
		}
		else if( in_f[0] == false && in_f[1] == true )
		{
			float		r	= ( limit - sp.m[xy] ) / ( tp.m[xy] - sp.m[xy] );
			fvector2	c	= trans.Transform(( tp - sp ) * r + sp);

			UpdateBoundBox( c );
			(*src)->x	= c.x;
			(*src)->y	= c.y;
			src		= &((*src)->m_next);
		}
		in_f[0]	= in_f[1];
		sp		= tp;
	}
}
// "IOutlineInfo" interface functions
public:
//=================================================================================================
bool cb_call GetOutlineInfo
		(
		OutlineInfo*	info
		)
{
	if( m_bound_exist == false )
		return false;
	info->m_boundbox	= m_boundbox;
	info->m_first		= m_first;
	return true;
}
// "IOutline" interface functions
public:
//=================================================================================================
void cb_call Reset()
{
	if( m_allocator != 0 )
		m_allocator->DeallocateAll();
	m_first			= 0;
	m_last			= 0;
	m_bound_exist	= false;
}
//=================================================================================================
void cb_call Copy
		(
		IOutlineInfo*	info
		)
{
	Reset();
	OutlineInfo		oi;
	if( false == info->GetOutlineInfo( &oi ) )
		return;
	const OutlineSeg*	os	= oi.m_first;
	while( os != 0 )
	{
		const OutlineNode*	sn	= os->m_node;
		OutlineNodePtr*		tn	= &CreateOutline()->m_node;
		while( sn != 0 )
		{
			tn	= InsertNode( tn , fvector2( sn->x , sn->y ) );
			sn	= sn->m_next;
		}
		os	= os->m_next;
	}
}
//=================================================================================================
OutlineSeg* cb_call CreateOutline()
{
	if( m_last == 0 )
	{
		OutlineSeg	*p = CreateOutlineSeg();
		m_first = p;
		m_last	= p;
	}
	else
	{
		OutlineSeg	*p = CreateOutlineSeg();
		m_last->m_next	= p;
		m_last			= p;
	}
	m_last->m_next	= 0;
	m_last->m_node	= 0;

	return m_last;
}
//=================================================================================================
OutlineNodePtr* cb_call InsertNode
		(
		OutlineNodePtr*		prev , 
		const fvector2&		pos
		)
{
	UpdateBoundBox( pos );
	OutlineNode*e	= CreateOutlineNode();
	e->x			= pos.x;
	e->y			= pos.y;
	e->m_next		= *prev;
	*prev			= e;
	return &e->m_next;
}
//=================================================================================================
OutlineNodePtr* cb_call InsertNode
		(
		OutlineNodePtr*		node , 
		const fvector2		pos[] , 
		int					num
		)
{
	int		off;
	for( off = 0 ; off < num ; off++ )
	{
		UpdateBoundBox( pos[off] );
		OutlineNode*e	= CreateOutlineNode();
		e->x			= pos[off].x;
		e->y			= pos[off].y;
		e->m_next		= *node;
		*node			= e;
		node			= &e->m_next;
	}
	return node;
}
//=================================================================================================
void cb_call Clip
		(
		const frect&		clip , 
		const faffine&		trans
		)
{
	m_bound_exist			= false;
	frect		c			= clip.Normalize();
	faffine		trans_inv	= trans.Inverse();
	OutlineSeg*	os			= m_first;
	while( os != 0 )
	{
		Clip<ClipMin , 0>( &os->m_node , trans , trans_inv ,  c.xmin );
		Clip<ClipMax , 0>( &os->m_node , trans , trans_inv ,  c.xmax );
		Clip<ClipMin , 1>( &os->m_node , trans , trans_inv ,  c.ymin );
		Clip<ClipMax , 1>( &os->m_node , trans , trans_inv ,  c.ymax );
		os	= os->m_next;
	}	
}
// protected functions
protected:
//=================================================================================================
//!	FreeAllocator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void FreeAllocator()
{
	Reset();
	m_allocator = 0;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Outline_bs
		(
		IMemAllocLump*		alloc
		) : 
		m_allocator( alloc ) , 
		m_first( 0 ) , 
		m_last( 0 ) , 
		m_bound_exist( false )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~Outline_bs()
{
	Reset();
}
};

/**************************************************************************************************
"Outline" class 
**************************************************************************************************/
class Outline : 
	virtual public object_base , 
	public Outline_bs
{
// query
	query_begin()
	iface_hook( IOutline , IOutline_IID )
	iface_hook( IOutlineInfo , IOutlineInfo_IID )
	query_end( object_base )

// variable member
private:
	MemAllocLump_inc	m_allocator;
		
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Outline() : Outline_bs( &m_allocator ) , m_allocator( 1024 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~Outline()
{
	FreeAllocator();
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
