/*************************************************************************************************/
/*!
   	@file		rendereroutline.h
	@author 	Fanzo
 	@date 		2008/4/6
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iRendererOutline.h"
#include	"iFace/iPaint.h"
#include	"iFace/iBlender.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"RendererOutline_bs" class 
**************************************************************************************************/
class RendererOutline_bs : 
	public IRendererOutline
{
	cb_copy_impossible( RendererOutline_bs );
	
// member class
protected:
	struct Edge
	{
		Edge*	m_next;
		int		m_x;
		int		m_cover;
		int		m_fx8;
	};
	struct Segment
	{
		int			m_sx;
		int			m_tx;
		uint8		m_alpha;
		Segment*	m_next;
	};
	class Scanline
	{
	public:
		Segment*			m_first;
		Segment*			m_last;
	};	

// member class
private:
	class Subpixel_alias
	{
	public:
		//=================================================================================================
		void AddSubpixelArea
				(
				Edge		*edge , 
				int			dc , 
				int			x_fx
				)
		{
			int		fx		= x_fx & outlinedgemap_anti_mask_x();
			int		d_area	= fx;
			if( dc == 1 )
			{
				edge->m_cover	+= dc;
				edge->m_fx8		+= -d_area;
			}
			else 
			{
				edge->m_cover	+= dc;
				edge->m_fx8		+= d_area;
			}
/*
			if( dc == 1 )
				edge->m_cover+= dc;
			else 
				edge->m_cover+= dc;
*/
		}
		//=================================================================================================
		uint8 CalcAlphaPoint
				(
				Edge*			edge , 
				int				cover , 
				int				anti_sft , 
				const int16*	gamma , 
				uint8			alpha
				)
		{
			uint32	a = ( uint32 )gamma[ ( ( cover << outlinedgemap_anti_shift_x() ) + edge->m_fx8 ) >> ( anti_sft + outlinedgemap_anti_shift_x() - 8 ) ];
			a	= a > 127 ? 255 : 0;
			return (uint8)(( alpha * a ) >> 8);
//			return alpha;
		}
		//=================================================================================================
		uint8 CalcAlphaLine
				(
				int				cover , 
				int				anti_sft , 
				const int16*	gamma , 
				uint8			alpha
				)
		{
			uint32	a = ( uint32 )gamma[ cover << ( 8 - anti_sft ) ];
			a	= a > 127 ? 255 : 0;
			return (uint8)( ( alpha * a ) >> 8 );
//			return alpha;
		}
		//=================================================================================================
		rgba CalcColor
				(
				const rgba&		c , 
				uint8			alpha
				)
		{
			return c.MulAlpha( alpha );
		}
	};
	class Subpixel_antialias
	{
	public:
		//=================================================================================================
		void AddSubpixelArea
				(
				Edge		*edge , 
				int			dc , 
				int			x_fx
				)
		{
			int		fx		= x_fx & outlinedgemap_anti_mask_x();
			int		d_area	= fx;
			if( dc == 1 )
			{
				edge->m_cover	+= dc;
				edge->m_fx8		+= -d_area;
			}
			else 
			{
				edge->m_cover	+= dc;
				edge->m_fx8		+= d_area;
			}
		}
		//=================================================================================================
		uint8 CalcAlphaPoint
				(
				Edge*			edge , 
				int				cover , 
				int				anti_sft , 
				const int16*	gamma , 
				uint8			alpha
				)
		{
			return ( alpha * ( uint32 )gamma[ ( ( cover << outlinedgemap_anti_shift_x() ) + edge->m_fx8 ) >> ( anti_sft + outlinedgemap_anti_shift_x() - 8 ) ] ) >> 8;
		}
		//=================================================================================================
		uint8 CalcAlphaLine
				(
				int				cover , 
				int				anti_sft , 
				const int16*	gamma , 
				uint8			alpha
				)
		{
			return ( alpha * ( uint32 )gamma[ cover << ( 8 - anti_sft ) ] ) >> 8;;
		}
		//=================================================================================================
		rgba CalcColor
				(
				const rgba&	c , 
				uint8		alpha
				)
		{
			return c.MulAlpha( alpha );
		}
	};

// variable member
private:
	rgba					m_color;
	
	// renderdata
	IMemAllocLump*			m_allocator;
	Array< Scanline >		m_scanline;
	Array<uint8>			m_imagebuf;
	
	// renderer
	iPaint					m_source;
	iBlender				m_blender;
	iNormTable_i16			m_gamma;

// private functions
private:
//=================================================================================================
//!	get gamma
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const int16* GetGammaTbl()
{
	if( m_gamma == false )
		return TableLinear_i16();
	return m_gamma->GetNormTable();
}
//=================================================================================================
//!	create Segment
//!	@retval			---
//-------------------------------------------------------------------------------------------------
Segment* CreateSegment()
{
	return ( Segment* )m_allocator->Allocate( sizeof( Segment ) );
}
//=================================================================================================
//!	create Edge
//!	@retval			---
//-------------------------------------------------------------------------------------------------
Edge* CreateEdge()
{
	return ( Edge* )m_allocator->Allocate( sizeof( Edge ) );
}
//=================================================================================================
//!	AntiToAliasEdge
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_subpixel >
Edge* AntiToAliasEdge
		(
		Edge*			t_edge , 
		OutlineEdge*	s_edge , 
		int				xmin_fx , 
		t_subpixel&		subcalc
		)
{
	Edge	first;
	first.m_x	= xmin_fx - 1;
	Edge  *prev = &first;

	int			s_dc		= 1;
	while( s_edge !=0 || t_edge != 0 )
	{
		int		sx = s_edge == 0 ? 0 : ( s_edge->x >> outlinedgemap_anti_shift_x() );

		if( ( s_edge != 0 && t_edge != 0 && t_edge->m_x <= sx ) || ( s_edge == 0 ) )
		{
			prev->m_next	= t_edge;
			prev			= t_edge;
			t_edge			= t_edge->m_next;
		}
		else if( sx == prev->m_x )
		{
			subcalc.AddSubpixelArea( prev , s_dc , s_edge->x );
			s_dc	= ( s_dc == 1 ) ? -1 : 1;
			s_edge	= s_edge->m_next;
		}
		else
		{
			Edge	*edge		= CreateEdge();
			edge->m_cover		= 0;
			edge->m_fx8			= 0;
			edge->m_x			= sx;
			subcalc.AddSubpixelArea( edge , s_dc , s_edge->x );
			prev->m_next	= edge;
			prev			= edge;

			s_dc	= ( s_dc == 1 ) ? -1 : 1;
			s_edge	= s_edge->m_next;
		}
	}
	prev->m_next = 0;
	return first.m_next;
}
//=================================================================================================
//!	outlineedge_to_render
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_subpixel >
Segment* EdgeToSegment
		(
		Edge			*edge , 
		Segment			**pplast , 
		antialias		anti , 
		t_subpixel&		subcalc , 
		uint8			alpha
		)
{
	const int16* gamma	= GetGammaTbl();

	int			anti_sft	= anti_shift( anti );
	Segment		first;
	Segment		*prev	= &first;
	int			cover = 0;
	
	while( edge != 0 )
	{
		cover += edge->m_cover;
		
		// point
//		if( cover != 0 )
		{
			Segment	*e		= CreateSegment();
			e->m_sx			= edge->m_x;
			e->m_tx			= edge->m_x + 1;
			e->m_alpha		= subcalc.CalcAlphaPoint( edge , cover , anti_sft , gamma , alpha );
			prev->m_next	= e;
			prev			= e;
		}
		// line
		if( edge->m_next != 0 && cover != 0 )
		{
			int		sx = edge->m_x + 1;
			int		tx = edge->m_next->m_x;

			if( sx < tx )
			{
				Segment	*e		= CreateSegment();
				e->m_sx			= sx;
				e->m_tx			= tx;
				e->m_alpha		= subcalc.CalcAlphaLine( cover , anti_sft , gamma , alpha );
				prev->m_next	= e;
				prev			= e;
			}
		}
		edge	= edge->m_next;
	}
	prev->m_next = 0;
	*pplast	= prev;
	return first.m_next;
}
//=================================================================================================
//!	UpdateScanline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_subpixel >
void UpdateScanline
		(
		int						y , 
		EdgemapOutlineInfo&		ei , 
		const irect&			g_area , 
		t_subpixel&				subcalc , 
		uint8					alpha
		)
{
	int		scanoff = y - g_area.ymin;
	if( m_scanline[ scanoff ].m_first != 0 )
		return;

	// anti to alias edge
	int		xmin_fx	= g_area.xmin << outlinedgemap_anti_shift_x();
	Edge	*edge = 0;
	{
		int		src_scanoff		= y - ei.m_area.ymin;
		int		s_scanoff		= src_scanoff << anti_shift( ei.m_antialias );
		int		t_scanoff		= ( src_scanoff + 1 ) << anti_shift( ei.m_antialias );
		int		scanoff;
		for( scanoff = s_scanoff ; scanoff < t_scanoff ; scanoff++ )
			edge = AntiToAliasEdge( edge , ei.m_line[ scanoff ].m_edge , xmin_fx , subcalc );
	}
	//edge to segment
	{
		Segment*	last;
		Segment*	first	= EdgeToSegment( edge , &last , ei.m_antialias , subcalc , alpha );
		m_scanline[ scanoff ].m_first	= first;
		m_scanline[ scanoff ].m_last	= last;
	}
}
//=================================================================================================
//!	RenderColor
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template <class t_subpixel>
void RenderSourceColor
		(
		iSurfaceDest&	surface , 
		const irect&	g_area , 
		const irect&	r_area , 
		t_subpixel&		subcalc
		)
{
	// params
	pixelformat		destformat		= surface->GetDestFormat();
	int				destpixbyte		= get_pixel_byte( destformat );
	int				destpitchbyte;
	uint8*			destpixel		= ( uint8* )surface->GetDestPixelPtr( &destpitchbyte );
	destpixel	+= r_area.ymin * destpitchbyte;
	rgba	color	= m_source->PaintColor();

	// render
	int		y;
	for( y = r_area.ymin ; y < r_area.ymax ; y++ )
	{
		Scanline	*pscan	= &m_scanline[ y - g_area.ymin ];
		if( pscan->m_first != 0 && ( r_area.xmin < pscan->m_last->m_tx && pscan->m_first->m_sx < r_area.xmax ) )
		{
			Segment*	segment = pscan->m_first;
			while( segment != 0 )
			{
				int		sx	= segment->m_sx;
				int		tx	= segment->m_tx;
				sx	= sx < r_area.xmin ? r_area.xmin : ( sx > r_area.xmax ? r_area.xmax : sx );
				tx	= tx < r_area.xmin ? r_area.xmin : ( tx > r_area.xmax ? r_area.xmax : tx );
				
				void	*p = destpixel + sx * destpixbyte;
				if( sx < tx )
				{
					int		len = tx - sx;
					m_blender->BlendColor( destformat , p , len , subcalc.CalcColor( color , segment->m_alpha ) );
				}
				// update
				segment	= segment->m_next;
			}
		}
		destpixel	+= destpitchbyte;
	}
}
//=================================================================================================
//!	RenderImage
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void RenderSourceImage
		(
		iSurfaceDest&		surface , 
		const irect&		g_area , 
		const irect&		r_area
		)
{
	// params
	pixelformat		srcformat		= m_source->PaintImageFormat();
	int				srcpixbyte		= get_pixel_byte( srcformat );
	pixelformat		destformat		= surface->GetDestFormat();
	int				destpixbyte		= get_pixel_byte( destformat );
	int				destpitchbyte;
	uint8*			destpixel		= ( uint8* )surface->GetDestPixelPtr( &destpitchbyte );
	destpixel	+= r_area.ymin * destpitchbyte;
	
	// render
	if( false == m_source->BeginPaintImage() )
		return;
	int		y;
	for( y = r_area.ymin ; y < r_area.ymax ; y++ )
	{
		Scanline	*pscan	= &m_scanline[ y - g_area.ymin ];
		if( pscan->m_first != 0 && ( r_area.xmin < pscan->m_last->m_tx && pscan->m_first->m_sx < r_area.xmax ) )
		{
			fvector2	sp( 0.0f , ( float )y + 0.5f ) , tp( 0.0f , ( float )y + 0.5f );
			Segment*	segment = pscan->m_first;
			while( segment != 0 )
			{
				int		sx	= segment->m_sx;
				int		tx	= segment->m_tx;
				sx	= sx < r_area.xmin ? r_area.xmin : ( sx > r_area.xmax ? r_area.xmax : sx );
				tx	= tx < r_area.xmin ? r_area.xmin : ( tx > r_area.xmax ? r_area.xmax : tx );
				
				void	*p = destpixel + sx * destpixbyte;
				if( sx < tx )
				{
					int		len = tx - sx;

					// source
					m_imagebuf.Resize( len * srcpixbyte );
					sp.x = ( float )sx;
					tp.x = ( float )tx;
					m_source->PaintImage( m_imagebuf.GetPtr() , len , sp , tp );
			
					// blend
					m_blender->BlendImage( destformat , p , srcformat , m_imagebuf.GetPtr() , len , m_color , segment->m_alpha );
				}
				// update
				segment	= segment->m_next;
			}
		}
		destpixel	+= destpitchbyte;
	}
	m_source->EndPaintImage();
}
//=================================================================================================
//!	render outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template <class t_subpixel>
void cb_call Render
		(
		iSurfaceDest&			surface , 
		EdgemapOutlineInfo&		ei , 
		const irect&			g_area , 
		const irect&			r_area , 
		t_subpixel&				subcalc , 
		uint8					alpha
		)
{
	if( m_blender == false )
		return;
	if( m_source == false )
		return;
	if( r_area.IsExist() == false )
		return;
		
	// update renderdata
	int		y;
	for( y = r_area.ymin ; y < r_area.ymax ; y++ )
		UpdateScanline( y ,  ei , g_area , subcalc , alpha );

	// render
	IPaint::Type	sf = m_source->PaintType();
	if( sf == IPaint::Color )
		RenderSourceColor( surface , g_area , r_area , subcalc );
	else if( sf == IPaint::Image )
		RenderSourceImage( surface , g_area , r_area );
}
// "IRendererOutline" interface functions
public:
//=================================================================================================
void cb_call Render
		(
		iSurfaceDest&			surface , 
		IEdgemapOutlineInfo*	info , 
		const irect				arealist[] , 
		int						areanum , 
		uint8					alpha = 255
		)
{
	if( areanum <= 0 )
		return;
	EdgemapOutlineInfo		ei = info->GetEdgemapOutlineInfo();
	
	// get area
	irect	area = arealist[0];
	int		areaoff;
	for( areaoff = 1 ; areaoff < areanum ; areaoff++ )
		area = area.Or( arealist[ areaoff ] );
	area = area.And( ei.m_area );
	area = area.And( surface->GetDestAvailableArea() );
	if( area.IsExist() == false )
		return;
		
	// initialize list
	m_scanline.Resize( area.Height() );
	int		off , num = m_scanline.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		m_scanline[ off ].m_first = 0;
		m_scanline[ off ].m_last = 0;
	}
	m_allocator->DeallocateAll();
	
	// render
	if( ei.m_antialias == none_antialias )
	{
		Subpixel_alias			subcalc;
		for( off = 0 ; off < areanum ; off++ )
			Render( surface , ei , area , arealist[off].And( area ) , subcalc , alpha );
	}
	else
	{
		Subpixel_antialias		subcalc;
		for( off = 0 ; off < areanum ; off++ )
			Render( surface , ei , area , arealist[off].And( area ) , subcalc , alpha );
	}
}

// public functions
public:
//=================================================================================================
RendererOutline_bs
		(
		IMemAllocLump*	alloc
		) : 
		m_allocator( alloc ) , 
		m_scanline( Expand_ArrayCashType , 64 ) , 
		m_imagebuf( Expand_ArrayCashType , 64 )
{
	cb_assert( m_allocator != 0 , L"Allocator isn't exist." );
}
//=================================================================================================
~RendererOutline_bs()
{
	ReleaseAllocator();
}
//=================================================================================================
void ReleaseAllocator()
{
	if( m_allocator == 0 )
		return;
	m_allocator->DeallocateAll();
	m_allocator = 0;
	m_scanline.Resize( 0 );
}
//=================================================================================================
//!	set blender
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetBlender
		(
		iBlender&		blender
		)
{
	m_blender	= blender;
}
//=================================================================================================
//!	release blender
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleaseBlender()
{
	m_blender.release();
}
//=================================================================================================
//!	set source generator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPaint
		(
		iPaint&		source
		)
{
	m_source	= source;
}
//=================================================================================================
//!	set source generator
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleasePaint()
{
	m_source.release();
}
//=================================================================================================
//!	set interpolate table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetGamma
		(
		iNormTable_i16&		gamma
		)
{
	m_gamma	= gamma;
}
//=================================================================================================
//!	release gamma
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void ReleaseGamma()
{
	m_gamma.release();
}
};

/**************************************************************************************************
"RendererOutline" class 
**************************************************************************************************/
class RendererOutline : 
		public RendererOutline_bs , 
		virtual public object_base
{
	query_begin();
	iface_hook( IRendererOutline , IRendererOutline_IID )
	query_end( object_base );

private:
	MemAllocLump_inc		m_allocator;
	
public:
//=================================================================================================
RendererOutline() : RendererOutline_bs( &m_allocator ) , m_allocator( sizeof( Edge ) * 512 )
{
}
//=================================================================================================
~RendererOutline()
{
	ReleaseAllocator();
}
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
