/*************************************************************************************************/
/*!
   	@file		Spline.h
	@author 	Fanzo
 	@date 		2008/4/10
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"MatrixMulti.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
enum SplineEdgetype
{
	Free_SplineEdgetype , 
	Fix_SplineEdgetype , 
	Loop_SplineEdgetype , 
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"fSpline_x" class 
**************************************************************************************************/
class fSpline_x
{
// member class
private:
	class Coeff
	{
	public:
		fvector2	m_pos;
		float		m_d;
		float		m_c;
		float		m_b;
		float		m_a;
		Coeff() : m_d( 0.0f ) , m_c( 0.0f ) , m_b( 0.0f ) , m_a( 0.0f ){}
	};
// variable member
private:
	Array< Coeff >	m_coeff;
	float			m_start_gradient;
	float			m_target_gradient;
	SplineEdgetype	m_edgetype;
	
// private functions
private:
//=================================================================================================
//!	UpdateCoeffA
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateCoeff_D()
{
	Coeff	*coeff	= &m_coeff[ 0 ];
	int		off , num = m_coeff.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		coeff->m_d = coeff->m_pos.y;
		coeff++;
	}
}
//=================================================================================================
//!	SetEdgeparam_B
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetEdgeparam_B
		(
		fVectorMatrixMulti&		vec
		)const
{
	int		num = m_coeff.GetDatanum();
	if( m_edgetype == Free_SplineEdgetype )
	{
		vec.Elem( 0 )		= 0.0f;
		vec.Elem( num - 1 ) = 0.0f;
	}
	else if( m_edgetype == Fix_SplineEdgetype )
	{
		{
			const Coeff	*coeff	= &m_coeff[ 0 ];
			float		h0		= (coeff+1)->m_pos.x - coeff->m_pos.x;
			vec.Elem( 0 )		= 3.0f * ( (coeff+1)->m_d - coeff->m_d ) / h0 - 3.0f * m_start_gradient;
		}
		{
			const Coeff		*coeff	= &m_coeff[ num - 2 ];
			float		h0		= (coeff+1)->m_pos.x - coeff->m_pos.x;
			vec.Elem( num - 1 )		= 3.0f * ( (coeff+1)->m_d - coeff->m_d ) / h0 - 3.0f * m_target_gradient;
		}
	}
	else if( m_edgetype == Loop_SplineEdgetype )
	{
		{
			const Coeff	*coeff	= &m_coeff[ 0 ];
			const Coeff	*e_coeff= &m_coeff[ num - 2 ];
			float		h0		= (coeff+1)->m_pos.x - coeff->m_pos.x;
			float		h1		= (e_coeff+1)->m_pos.x - e_coeff->m_pos.x;
			vec.Elem( 0 )		= 3.0f * ( (coeff+1)->m_d - coeff->m_d ) / h0 - 3.0f * ( (e_coeff+1)->m_d - e_coeff->m_d ) / h1;
		}
		vec.Elem( num - 1 )		= 0.0f;
	}
}
//=================================================================================================
//!	SetEdgeparam_Vec_B
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetEdgeparam_B
		(
		fSquareMatrixMulti&		mt
		)const
{
	int		num = m_coeff.GetDatanum();
	if( m_edgetype == Free_SplineEdgetype )
	{
	}
	else if( m_edgetype == Fix_SplineEdgetype )
	{
		const Coeff	*coeff	= &m_coeff[ 0 ];
		float		h0		= (coeff+1)->m_pos.x - coeff->m_pos.x;
		mt.Elem( 0 , 0 )	= 2.0f * h0;
		mt.Elem( 0 , 1 )	= h0;

		coeff	= &m_coeff[ num - 2 ];
		h0		= (coeff+1)->m_pos.x - coeff->m_pos.x;
		mt.Elem( num-1 , num-2 ) = -h0;
		mt.Elem( num-1 , num-1 ) = -2.0f * h0;
	}
	else if( m_edgetype == Loop_SplineEdgetype )
	{
		const Coeff	*coeff		= &m_coeff[ 0 ];
		float		h0			= (coeff+1)->m_pos.x - coeff->m_pos.x;
		mt.Elem( 0 , 0 )		= -2.0f * h0;
		mt.Elem( 0 , 1 )		= h0;
		mt.Elem( num-1 , num-1 )= -1.0f;
	}
}
//=================================================================================================
//!	UpdateCoeff
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool UpdateCoeff_B()
{
	int		num = m_coeff.GetDatanum();
	
	// vector edge
	fVectorMatrixMulti	vec( num );

	// vector
	{
		SetEdgeparam_B( vec );
		Coeff	*coeff	= &m_coeff[ 0 ];
		int		off , num = m_coeff.GetDatanum();
		for( off = 1 ; off < num - 1 ; off++ )
		{
			float	h0	= ( coeff + 1 )->m_pos.x - coeff->m_pos.x;
			float	h1	= ( coeff + 2 )->m_pos.x - ( coeff + 1 )->m_pos.x;
			vec.Elem( off )	= 3.0f * ( ( coeff+2 )->m_pos.y - ( coeff+1)->m_pos.y ) / h1
							- 3.0f * ( ( coeff+1 )->m_pos.y - ( coeff)->m_pos.y ) / h0;
			coeff++;
		}
	}
	// matrix
	fSquareMatrixMulti	rmt( num );
	{
		fSquareMatrixMulti	mt( num );
		mt.SetUnit();

		SetEdgeparam_B( mt );
		Coeff	*coeff	= &m_coeff[ 0 ];
		int		off , num = m_coeff.GetDatanum();
		for( off = 1 ; off < num - 1 ; off++ )
		{
			float	h0 = ( coeff + 1 )->m_pos.x - coeff->m_pos.x;
			float	h1 = ( coeff + 2 )->m_pos.x - ( coeff + 1 )->m_pos.x;
			mt.Elem( off , off - 1 )	= h0;
			mt.Elem( off , off )		= 2.0f * ( h0 + h1 );
			mt.Elem( off , off + 1 )	= h1;
			coeff++;
		}
		if( false == mt.GetInverse( &rmt ) )
			return false;
	}
	fVectorMatrixMulti	rvec = rmt * vec;
	
	// store
	int		off;
	for( off = 0 ; off < num - 1 ; off++ )
	{
		m_coeff[ off ].m_b = rvec.Elem( off );
	}
	m_coeff[ num - 1 ].m_b = 0.0f;
	return true;
}
//=================================================================================================
//!	update coeff
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool UpdateCoeff()
{
	int		num = m_coeff.GetDatanum();
	if( num <= 1 )
		return false;
		
	UpdateCoeff_D();
	if( false == UpdateCoeff_B() )
		return false;
	
	Coeff	*coeff	= &m_coeff[ 0 ];
	int		off;
	for( off = 0 ; off < num - 1 ; off++ )
	{
		float	h	= (coeff+1)->m_pos.x - (coeff)->m_pos.x;
		coeff->m_c	= ( (coeff+1)->m_d - coeff->m_d ) / h - h * ( (coeff+1)->m_b + 2.0f * coeff->m_b ) / 3.0f;
		coeff->m_a	= ( (coeff+1)->m_b - coeff->m_b ) / 3.0f / h;
		coeff++;
	}
	return true;
}
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
fSpline_x() : 
		m_edgetype( Free_SplineEdgetype ) , 
		m_start_gradient( 0.0f ) , 
		m_target_gradient( 0.0f )
{
}
//=================================================================================================
//!	SetEdgetype
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetEdgetype
		(
		SplineEdgetype		edgetype
		)
{
	m_edgetype	= edgetype;
}
//=================================================================================================
//!	GetEdgetype
//!	@retval			---
//-------------------------------------------------------------------------------------------------
SplineEdgetype GetEdgetype()const
{
	return m_edgetype;
}
//=================================================================================================
//!	SetEdgeGradient
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool SetEdgeGradient
		(
		float	s , 
		float	t
		)
{
	if( s == 0.0f || t == 0.0f )
		return false;
	m_start_gradient	= s;
	m_target_gradient	= t;
	return true;
}
//=================================================================================================
//!	getEdgeGradient
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GetEdgeGradient
		(
		float	*s , 
		float	*t
		)const
{
	if( s != 0 )	*s = m_start_gradient;
	if( t != 0 )	*t = m_target_gradient;
}
//=================================================================================================
//!	set point
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPoints
		(
		const fvector2	points[] ,		//!< [in]  point[ 0 ].x < point[ 1 ].x < ... < point[ n-1 ].x
		int				pointnum
		)
{
	m_coeff.Resize( pointnum );
	int		off;
	for( off = 0 ; off < pointnum ; off++ )
	{
		m_coeff[ off ].m_pos = points[ off ];
	}
}
//=================================================================================================
//!	update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool Update()
{
	return UpdateCoeff();
}
//=================================================================================================
//!	GetSetmentNum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetSegmentNum()
{
	return m_coeff.GetDatanum() - 1;
}
//=================================================================================================
//!	GetSetmentparam
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GetSegmentParam
		(
		int			segoff , 
		float		*a , 
		float		*b , 
		float		*c , 
		float		*d , 
		fvector2	*sp , 
		fvector2	*tp
		)
{
	cb_assert( 0 <= segoff && segoff < m_coeff.GetDatanum() , L"Spline_x:out of segoff" );
	Coeff	*coeff = &m_coeff[ segoff ];
	
	if( a != 0 )	*a = coeff->m_a;
	if( b != 0 )	*b = coeff->m_b;
	if( c != 0 )	*c = coeff->m_c;
	if( d != 0 )	*d = coeff->m_d;
	if( sp != 0 )	*sp= coeff->m_pos;
	if( tp != 0 )	*tp= (coeff+1)->m_pos;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetValue
		(
		float		x
		)
{
	int		num = m_coeff.GetDatanum();
	if( num == 0 )
		return 0.0f;
	
	int		off = 0;
	if( x <= m_coeff[ 0 ].m_pos.x  )
		off = 0;
	else if( x >= m_coeff[ num - 1 ].m_pos.x )
		off = num - 2;
	else
	{
		for( ; off < num - 2 ; off++ )
		{
			if( m_coeff[ off ].m_pos.x <= x && x <= m_coeff[ off + 1 ].m_pos.x )
				break;
		}
	}
	Coeff	*coeff = &m_coeff[ off ];
	
	float	dx		= x - coeff->m_pos.x;
	float	dxp2	= dx * dx;
	return coeff->m_d + coeff->m_c * dx + coeff->m_b * dxp2 + coeff->m_a * dx * dxp2;
}
};


/**************************************************************************************************
"fSpline_t" class 
**************************************************************************************************/
class fSpline_t
{
// member class
private:
	class Coeff
	{
	public:
		float		m_val;
		float		m_d;
		float		m_c;
		float		m_b;
		float		m_a;
		Coeff() : m_val( 0.0f ) , m_d( 0.0f ) , m_c( 0.0f ) , m_b( 0.0f ) , m_a( 0.0f ){}
	};
// variable member
private:
	Array< Coeff >	m_coeff;
	float			m_start_gradient;
	float			m_target_gradient;
	SplineEdgetype	m_edgetype;
	
// private functions
private:
//=================================================================================================
//!	UpdateCoeffA
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateCoeff_D()
{
	Coeff	*coeff	= &m_coeff[ 0 ];
	int		off , num = m_coeff.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		coeff->m_d = coeff->m_val;
		coeff++;
	}
}
//=================================================================================================
//!	SetEdgeparam_B
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetEdgeparam_B
		(
		fVectorMatrixMulti&		vec
		)const
{
	int		num = m_coeff.GetDatanum();
	if( m_edgetype == Free_SplineEdgetype )
	{
		vec.Elem( 0 )		= 0.0f;
		vec.Elem( num - 1 ) = 0.0f;
	}
	else if( m_edgetype == Fix_SplineEdgetype )
	{
		{
			const Coeff	*coeff	= &m_coeff[ 0 ];
			vec.Elem( 0 )		= 3.0f * ( (coeff+1)->m_d - coeff->m_d ) - 3.0f * m_start_gradient;
		}
		{
			const Coeff		*coeff	= &m_coeff[ num - 2 ];
			vec.Elem( num - 1 )		= 3.0f * ( (coeff+1)->m_d - coeff->m_d ) - 3.0f * m_target_gradient;
		}
	}
	else if( m_edgetype == Loop_SplineEdgetype )
	{
		{
			const Coeff	*coeff	= &m_coeff[ 0 ];
			const Coeff	*e_coeff= &m_coeff[ num - 2 ];
			vec.Elem( 0 )		= 3.0f * ( (coeff+1)->m_d - coeff->m_d ) - 3.0f * ( (e_coeff+1)->m_d - e_coeff->m_d );
		}
		vec.Elem( num - 1 )		= 0.0f;
	}
}
//=================================================================================================
//!	SetEdgeparam_Vec_B
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetEdgeparam_B
		(
		fSquareMatrixMulti&		mt
		)const
{
	int		num = m_coeff.GetDatanum();
	if( m_edgetype == Free_SplineEdgetype )
	{
	}
	else if( m_edgetype == Fix_SplineEdgetype )
	{
		const Coeff	*coeff	= &m_coeff[ 0 ];
		mt.Elem( 0 , 0 )	= 2.0f ;
		mt.Elem( 0 , 1 )	= 1.0f;

		coeff	= &m_coeff[ num - 2 ];
		mt.Elem( num-1 , num-2 ) = -1.0f;
		mt.Elem( num-1 , num-1 ) = -2.0f;
	}
	else if( m_edgetype == Loop_SplineEdgetype )
	{
		const Coeff	*coeff		= &m_coeff[ 0 ];
		mt.Elem( 0 , 0 )		= -2.0f;
		mt.Elem( 0 , 1 )		= 1.0f;
		mt.Elem( num-1 , num-1 )= -1.0f;
	}
}
//=================================================================================================
//!	UpdateCoeff
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool UpdateCoeff_B()
{
	int		num = m_coeff.GetDatanum();
	
	// vector edge
	fVectorMatrixMulti	vec( num );

	// vector
	{
		SetEdgeparam_B( vec );
		Coeff	*coeff	= &m_coeff[ 0 ];
		int		off , num = m_coeff.GetDatanum();
		for( off = 1 ; off < num - 1 ; off++ )
		{
			vec.Elem( off )	= 3.0f * ( ( coeff+2 )->m_val - ( coeff+1)->m_val )
							- 3.0f * ( ( coeff+1 )->m_val - ( coeff)->m_val );
			coeff++;
		}
	}
	// matrix
	fSquareMatrixMulti	rmt( num );
	{
		fSquareMatrixMulti	mt( num );
		mt.SetUnit();

		SetEdgeparam_B( mt );
		Coeff	*coeff	= &m_coeff[ 0 ];
		int		off , num = m_coeff.GetDatanum();
		for( off = 1 ; off < num - 1 ; off++ )
		{
			mt.Elem( off , off - 1 )	= 1.0f;
			mt.Elem( off , off )		= 4.0f;
			mt.Elem( off , off + 1 )	= 1.0f;
			coeff++;
		}
		if( false == mt.GetInverse( &rmt ) )
			return false;
	}
	fVectorMatrixMulti	rvec = rmt * vec;
	
	// store
	int		off;
	for( off = 0 ; off < num - 1 ; off++ )
	{
		m_coeff[ off ].m_b = rvec.Elem( off );
	}
	m_coeff[ num - 1 ].m_b = 0.0f;
}
//=================================================================================================
//!	update coeff
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void UpdateCoeff()
{
	int		num = m_coeff.GetDatanum();
	if( num <= 1 )
		return;
		
	UpdateCoeff_D();
	UpdateCoeff_B();
	
	Coeff	*coeff	= &m_coeff[ 0 ];
	int		off;
	for( off = 0 ; off < num - 1 ; off++ )
	{
		coeff->m_c	= ( (coeff+1)->m_d - coeff->m_d ) - ( (coeff+1)->m_b + 2.0f * coeff->m_b ) / 3.0f;
		coeff->m_a	= ( (coeff+1)->m_b - coeff->m_b ) / 3.0f;
		coeff++;
	}			
}
// protect functions
protected:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
fSpline_t() : 
		m_edgetype( Free_SplineEdgetype ) , 
		m_start_gradient( 0.0f ) , 
		m_target_gradient( 0.0f )
{
}
//=================================================================================================
//!	SetEdgetype
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetEdgetype
		(
		SplineEdgetype		edgetype
		)
{
	m_edgetype	= edgetype;
}
//=================================================================================================
//!	GetEdgetype
//!	@retval			---
//-------------------------------------------------------------------------------------------------
SplineEdgetype GetEdgetype()const
{
	return m_edgetype;
}
//=================================================================================================
//!	SetEdgeGradient
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool SetEdgeGradient
		(
		float	s , 
		float	t
		)
{
	if( s == 0.0f || t == 0.0f )
		return false;
	m_start_gradient	= s;
	m_target_gradient	= t;
}
//=================================================================================================
//!	getEdgeGradient
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GetEdgeGradient
		(
		float	*s , 
		float	*t
		)
{
	if( s != 0 )	*s = m_start_gradient;
	if( t != 0 )	*t = m_target_gradient;
}
//=================================================================================================
//!	set point
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetPoints
		(
		float			vals[] ,
		int				valnum
		)
{
	m_coeff.Resize( valnum );
	int		off;
	for( off = 0 ; off < valnum ; off++ )
	{
		m_coeff[ off ].m_val = vals[ off ];
	}
}
//=================================================================================================
//!	update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Update()
{
	UpdateCoeff();
}
//=================================================================================================
//!	GetSetmentNum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int GetSegmentNum()
{
	return m_coeff.GetDatanum() - 1;
}
//=================================================================================================
//!	GetSetmentparam
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void GetSegmentParam
		(
		int			segoff , 
		float		*a , 
		float		*b , 
		float		*c , 
		float		*d , 
		float		*sval , 
		float		*tval
		)
{
	cb_assert( 0 <= segoff && segoff < m_coeff.GetDatanum() , L"out of segoff" );
	Coeff	*coeff = &m_coeff[ segoff ];
	
	if( a != 0 )	*a = coeff->m_a;
	if( b != 0 )	*b = coeff->m_b;
	if( c != 0 )	*c = coeff->m_c;
	if( d != 0 )	*d = coeff->m_d;
	if( sval != 0 )	*sval= coeff->m_val;
	if( tval != 0 )	*tval= (coeff+1)->m_val;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetValue
		(
		int			segoff , 
		float		t
		)
{
	Coeff	*coeff = &m_coeff[ segoff ];
	
	float	tp2	= t * t;
	return coeff->m_d + coeff->m_c * t + coeff->m_b * tp2 + coeff->m_a * t * tp2;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
