/*************************************************************************************************/
/*!
   	@file		Treedata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iTreedata.h"
#include	"Straightdata.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TreeNode_bs" class 
**************************************************************************************************/
template<class t_interface>
class t_TreeNode : 
	virtual public object_base , 
	public t_interface
{
// query
	query_begin();
	iface_hook( ITreeNode , ITreeNode_IID )
	query_end( object_base );
	
// variable member
protected:
	rTreeNode					m_parent;
	Straightdata<iTreeNode>		m_children;
	
// private functions
private:


// "ITreeNode" interface functions
public:
//=================================================================================================
//!	don,t parent link
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetParentWithoutLink
		(
		iTreeNode&		parent
		)
{
	m_parent	= parent;
}
//=================================================================================================
//!	get parent
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTreeNode cb_call GetParent()
{
	return m_parent.lock();
}
//=================================================================================================
//!	get childnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetChildnum()
{
	return m_children.GetDatanum();
}
//=================================================================================================
//!	get child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTreeNode cb_call GetChild
		(
		int		childoff
		)
{
	if( childoff < 0 || childoff >= m_children.GetDatanum() )
		return iTreeNode();
	return m_children[ childoff ];
}
//=================================================================================================
//!	insert child
//!	@retval			if error , return -1
//-------------------------------------------------------------------------------------------------
int cb_call InsertChild
		(
		iTreeNode&		child , 
		int				insertpos
		)
{
	if( child == false )
		return -1;

	if( insertpos < 0 )
		insertpos = 0;
	if( insertpos > m_children.GetDatanum() )
		insertpos = m_children.GetDatanum();
	
	int	choff = SearchChild( child );
	if( choff != -1 )
	{
		if( insertpos < choff )
		{
			m_children[m_children.Insert( insertpos )] = child;
			m_children.Delete( choff+1 );
		}
		else if( insertpos > choff )
		{
			m_children[m_children.Insert( insertpos )] = child;
			m_children.Delete( choff );
		}
	}
	else
	{
		child->Remove();
		child->SetParentWithoutLink( (iTreeNode)this_object() );
		m_children[ m_children.Insert( insertpos ) ] = child;
	}
	return insertpos;
}
//=================================================================================================
//!	search child
//!	@retval			if not exist return -1
//-------------------------------------------------------------------------------------------------
int cb_call SearchChild
		(
		iTreeNode&		child
		)
{
	int		off , num = m_children.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( ( object )m_children[ off ] == ( object )child )
			return off;
	}
	return -1;
}
//=================================================================================================
//!	remove child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call RemoveChild
		(
		int		childoff
		)
{
	m_children[ childoff ]->SetParentWithoutLink( iTreeNode() );
	m_children.Delete( childoff );
}
//=================================================================================================
//!	remove
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Remove()
{
	iTreeNode	parent = GetParent();
	if( parent == false )
		return false;
	int		childoff = parent->SearchChild( (iTreeNode)this_object() );
	cb_assert( childoff != -1 , L"algolithm error." );
	parent->RemoveChild( childoff );
	return true;
}
//=================================================================================================
//!	search node
//!	@retval			if exist return true.
//-------------------------------------------------------------------------------------------------
bool cb_call Search
		(
		iTreeNode&		node
		)
{
	if( this_object() == ( object )node )
		return true;
	int		off , num = m_children.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( true == m_children[off]->Search( node ) )
			return true; 
	}
	return false;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
t_TreeNode()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
