/*************************************************************************************************/
/*!
   	@file		CheckBox.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ICheckBoxMsg" interface 
***************************************************************************************************/
cb_guid_define( ICheckBoxMsg_IID , 0x2818E14E , 0x39334e2a , 0xB831E702 , 0xF6FEB85E );
class ICheckBoxMsg;
typedef icubic::iface_object< ICheckBoxMsg , ICheckBoxMsg_IID >		iCheckBoxMsg;
typedef icubic::iface_reference< ICheckBoxMsg , ICheckBoxMsg_IID >	rCheckBoxMsg;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ICheckBoxMsg
{
public:
//=================================================================================================
//!	Checked_checkbox
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ValueChanged_checkbox
		(
		int		id
		) = 0;
};

/**************************************************************************************************
"CheckBox" class 
**************************************************************************************************/
class CheckBox : public View
{
	msg_view_map_begin()
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( LButtonDown , OnLButtonDown )
	msg_view_hook( LButtonUp , OnLButtonUp )
	msg_view_hook( LDragStart , OnLDragStart )
	msg_view_hook( LDrag , OnLDrag )
	msg_view_hook( LDragEnd , OnLDragEnd )
	msg_view_map_end( View )

// variable member
private:
	wstring								m_string;
	instance<Font>					m_font;
	bool								m_check;
	rCheckBoxMsg						m_msg;
	int									m_id;
	
	instance<PaintSolidColor>		m_back;
	
// msg functions
protected:
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	fvector2	pos( 20.0f , GetRect().Size().height / 2.0f );
	DrawText( (iSurfaceDest)p->m_surface , pos , m_string.c_str() , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	
	float		c = 3.0f , r = 5.0f , w = 1.0f , wc = 2.0f;
	fvector2	cp( 10.0f , GetRect().Size().height / 2.0f );
	DrawRectStroke( (iSurfaceDest)p->m_surface , irect( ( int )( cp.x - r ) , ( int )( cp.y - r ) , ( int )( cp.x + r ) , ( int )( cp.y + r ) ) , w , rgb( 0 , 0 , 0 ) );
	if( m_check == true )
		DrawCheck( (iSurfaceDest)p->m_surface , irect( ( int )( cp.x - c ) , ( int )( cp.y - c ) , ( int )( cp.x + c ) , ( int )( cp.y + c ) ) , wc , rgb( 0 , 150 , 0 ) );
}
//=================================================================================================
void OnLButtonDown
		(
		LButtonDown_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLButtonUp
		(
		LButtonUp_ViewPM*	p
		)
{
	m_check	= m_check == true ? false : true;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
	iCheckBoxMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_checkbox( m_id );
}
//=================================================================================================
void OnLDragStart
		(
		LDragStart_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDrag
		(
		LDrag_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDragEnd
		(
		LDragEnd_ViewPM*	p
		)
{
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
CheckBox() : m_check( true ) , m_id( 0 )
{
	 cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetString
		(
		const wstring&		str
		)
{
	m_string	= str;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rCheckBoxMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set check
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		bool	ck
		)
{
	m_check	= ck;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	get check
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetValue()const
{
	return m_check;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace CheckBox;		

#pragma pack( pop )			//release align
