/*************************************************************************************************/
/*!
   	@file		PenCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PenCfgView" class 
**************************************************************************************************/
class PenCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )

	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<SeparateView>		m_gentype_t;
	instance<RadioGroupView>		m_gentype;
	instance<SeparateView>		m_width_t;
	instance<WidthCfgView>		m_width;
	instance<SeparateView>		m_start_cap_t;
	instance<CapCfgView_gp>		m_start_cap;
	instance<SeparateView>		m_center_cap_t;
	instance<CapCfgView_gp>		m_center_cap;
	instance<SeparateView>		m_end_cap_t;
	instance<CapCfgView_gp>		m_end_cap;
	instance<SeparateView>		m_loop_t;
	instance<LoopCfgView>		m_loop;
	instance<SeparateView>		m_joint_t;
	instance<JointCfgView_gp>	m_joint;
	instance<SeparateView>		m_bridge_t;
	instance<InnerBridgeCfgView>	m_bridge;
	instance<SeparateView>		m_dash_t;
	instance<DashCfgView>		m_dash;

	iPen_gp							m_pen;
	
	rControlMsg						m_msg;
	int								m_id;
	const int						m_ts;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	m_pen.release();
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// private functions
private:
//=================================================================================================
template<class t_class>
int CreateItem
		(
		Create_ViewPM*					p , 
		t_class&						item , 
		instance<SeparateView>&		title , 
		const wchar_t*					titlename ,
		int								y ,  
		int								view_height
		)
{
	title->SetString( titlename );
	title->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( 0 , y ) , isize( p->m_rect.Width() , m_ts ) ) );
	y += title->GetRect().Height();
	item->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( 0 , y ) , isize( p->m_rect.Width() , view_height ) ) );
	item->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	y += item->GetRect().Size().height;
	return y;
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		y = 0;
	m_gentype->SetRadioNum( 2 );
	m_gentype->SetString( 0 , L"stroke" );
	m_gentype->SetString( 1 , L"dash" );
	y = CreateItem( p , m_gentype , m_gentype_t , L"stroke type" , y , 30 );
	m_width->SetRange( 0.0f , 10.0f );
	y = CreateItem( p , m_width , m_width_t , L"width" , y , 15 );
	m_width->SetValue( 2.0f );
	y = CreateItem( p , m_start_cap , m_start_cap_t , L"start cap" , y , 45 );
	y = CreateItem( p , m_center_cap , m_center_cap_t , L"dash cap" , y , 45 );
	y = CreateItem( p , m_end_cap , m_end_cap_t , L"end cap" , y , 45 );
	y = CreateItem( p , m_loop , m_loop_t , L"loop state" , y , 30 );
	m_loop->SetValue( false );
	y = CreateItem( p , m_joint , m_joint_t , L"joint type" , y , 45 );
	y = CreateItem( p , m_bridge , m_bridge_t , L"bridge type" , y , 45 );
	m_dash->SetRange( 0.001f , 20.0f );
	y = CreateItem( p , m_dash , m_dash_t , L"dash interval" , y , 60 );
	m_dash->SetDash( 2.0f );
}
// private functions
private:
//=================================================================================================
void Update()
{
	if( m_pen == true )
		return;
	if( 0 == m_gentype->GetSelect() )
	{
		m_pen = CreatePenStroke
				(
				m_joint->GetValue() , 
				m_start_cap->GetValue() , 
				m_end_cap->GetValue() , 
				m_bridge->GetValue()
				);
	}
	else
	{
		m_pen = CreatePenDash
				(
				m_dash->GetDashNum() , 
				m_dash->GetDash() , 
				m_joint->GetValue() , 
				m_start_cap->GetValue() , 
				m_center_cap->GetValue() , 
				m_end_cap->GetValue() , 
				m_bridge->GetValue()
				);
	}
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PenCfgView() : m_id( 0 ) , m_ts( 11 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get pen
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPen_gp GetPen()
{
	Update();
	return m_pen;
}
//=================================================================================================
//!	get width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetWidth()
{
	return m_width->GetValue();
}
//=================================================================================================
//!	get close
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetClose()
{
	return m_loop->GetValue();
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
