/*************************************************************************************************/
/*!
   	@file		SampleScaleCfgView.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SampleScaleCfgView" class 
**************************************************************************************************/
class SampleScaleCfgView : public View , public ISliderMsg
{
	query_begin()
	iface_hook( ISliderMsg , ISliderMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	instance<Slider>					m_samplescale;
	instance<Font>					m_font;
	
	rControlMsg							m_msg;
	int									m_id;
	
	const float							m_min;
	const float							m_max;
	const int							m_sh;
	const int							m_info_w;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_slider
		(
		int		id
		)
{
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_samplescale->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_samplescale->SetValue( 0.0f );
	m_samplescale->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 100 );
	SetValue( 1.0f );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	wchar_t	text[ 256 ];
	cb_swprintf( text , L"D:%.2f" , GetValue() );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( ( float )( GetRect().Size().width - m_info_w ) , ( float )( m_sh / 2 ) ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SampleScaleCfgView() : m_sh( 15 ) , m_info_w( 30 ) , m_id( 0 ) , m_min( 0.0f ) , m_max( 10.0f )
{
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		float		d
		)
{
	d	= d < m_min ? m_min : d > m_max ? m_max : d;
	float	t = ( d - m_min ) / ( m_max - m_min );
	m_samplescale->SetValue( t );
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetValue()
{
	return m_samplescale->GetValue() * ( m_max - m_min ) + m_min;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SampleScaleCfgView;		

#pragma pack( pop )			//release align
