/*************************************************************************************************/
/*!
   	@file		SliderCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SliderCfgView" class 
**************************************************************************************************/
class SliderCfgView : public View , public ISliderMsg
{
	query_begin()
	iface_hook( ISliderMsg , ISliderMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	instance<Slider>		m_slider;
	instance<Font>		m_font;
	wstring					m_format;
	float					m_min;
	float					m_max;
	
	rControlMsg				m_msg;
	int						m_id;
		
	const int				m_sh;
	const int				m_info_w;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_slider
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_slider->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_slider->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 100 );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	wchar_t	text[ 256 ];
	cb_swprintf( text , m_format.c_str() , GetValue() );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( ( float )( GetRect().Size().width - m_info_w ) , ( float )(  m_sh / 2 ) ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SliderCfgView() : 
		m_sh( 15 ) , 
		m_info_w( 40 ) , 
		m_id( 0 ) , 
		m_min( -100.0f ) , 
		m_max( 100.0f ) , 
		m_format( L"%f" )
{
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
	SetValue( 10.0f );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetFormat
		(
		const wstring&	format
		)
{
	m_format	= format;
}
//=================================================================================================
//!	set scope
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetRange
		(
		float		min , 
		float		max
		)
{
	m_min	= min;
	m_max	= min <= max ? max : min;
	SetValue( m_slider->GetValue() );
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		float		d
		)
{
	d	= d < m_min ? m_min : d > m_max ? m_max : d;
	float	t = ( d - m_min ) / ( m_max - m_min );
	m_slider->SetValue( t );
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float GetValue()
{
	return m_slider->GetValue() * ( m_max - m_min ) + m_min;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SliderCfgView;		

#pragma pack( pop )			//release align
