/*************************************************************************************************/
/*!
   	@file		SourceGenCfgView.h
	@author 	Fanzo
 	@date 		2008/6/4
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SourceGenCfgView" class 
**************************************************************************************************/
class SourceGenCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioGroupView>						m_select;
	instance<SourceGenSolidCfgView>		m_solidcolor;
	instance<SourceGenGradationLinearCfgView>	m_gradlinear;
	instance<SourceGenGradationRadialCfgView>	m_gradradial;
	instance<SourceGenTextureNearestCfgView>	m_texnearest;
	instance<SourceGenTextureWeight4CfgView>	m_texweight4;
	instance<SourceGenTextureWeight16CfgView>	m_texweight16;

	rControlMsg			m_msg;
	int					m_id;

	const int			m_item_h;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 0 )
	{
		if( m_select->GetSelect() == 0 )
			m_solidcolor->Show( true );
		else
			m_solidcolor->Show( false );
		if( m_select->GetSelect() == 1 )
			m_gradlinear->Show( true );
		else
			m_gradlinear->Show( false );
		if( m_select->GetSelect() == 2 )
			m_gradradial->Show( true );
		else
			m_gradradial->Show( false );
		if( m_select->GetSelect() == 3 )
			m_texnearest->Show( true );
		else
			m_texnearest->Show( false );
		if( m_select->GetSelect() == 4 )
			m_texweight4->Show( true );
		else
			m_texweight4->Show( false );
		if( m_select->GetSelect() == 5 )
			m_texweight16->Show( true );
		else
			m_texweight16->Show( false );
	}
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Horz_RadioAlign );
	m_select->SetRadioNum( 6 );
	m_select->SetString( 0 , L"solid" );
	m_select->SetString( 1 , L"linear" );
	m_select->SetString( 2 , L"radial" );
	m_select->SetString( 3 , L"nearest" );
	m_select->SetString( 4 , L"weight4" );
	m_select->SetString( 5 , L"weight16" );
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_item_h ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	
	m_solidcolor->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 0
			);
	m_solidcolor->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	
	m_gradlinear->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 1
			);
	m_gradlinear->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_gradradial->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 2
			);
	m_gradradial->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_texnearest->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 3
			);
	m_texnearest->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_texweight4->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 4
			);
	m_texweight4->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_texweight16->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( p->m_rect.Size().width , p->m_rect.Size().height - m_item_h ) ) , 
			m_select->GetSelect() == 5
			);
	m_texweight16->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SourceGenCfgView() : 
		m_item_h( 20 ) , 
		m_id( 0 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	add texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddTexture
		(
		const wstring&	path
		)
{
	if( false ==  m_texnearest->AddTexture( path ) )
		return false;
	if( false ==  m_texweight4->AddTexture( path ) )
		return false;
	if( false ==  m_texweight16->AddTexture( path ) )
		return false;
	return true;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint GetSourcePaint
		(
		const DPI&			dpi , 
		const faffine&		aff
		)
{
	int		type = m_select->GetSelect();
	if( type == 0 )
		return m_solidcolor->GetSourcePaint();
	else if( type == 1 )
		return m_gradlinear->GetSourcePaint( aff );
	else if( type == 2 )
		return m_gradradial->GetSourcePaint( aff );
	else if( type == 3 )
		return m_texnearest->GetSourcePaint( dpi , aff );
	else if( type == 4 )
		return m_texweight4->GetSourcePaint( dpi , aff );
	else if( type == 5 )
		return m_texweight16->GetSourcePaint( dpi , aff );
	return m_solidcolor->GetSourcePaint();
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iTexture GetSourceTexture
		(
		const faffine&		aff
		)
{
	int		type = m_select->GetSelect();
	if( type == 0 )
		return m_solidcolor->GetSourceTexture();
	else if( type == 1 )
		return m_solidcolor->GetSourceTexture();
//		return m_gradlinear->GetSourceTexture( aff );
	else if( type == 2 )
		return m_solidcolor->GetSourceTexture();
//		return m_gradradial->GetSourceTexture( aff );
	else if( type == 3 )
		return m_texnearest->GetSourceTexture( aff );
	else if( type == 4 )
		return m_texweight4->GetSourceTexture( aff );
	else if( type == 5 )
		return m_texweight16->GetSourceTexture( aff );
	return m_solidcolor->GetSourceTexture();
}
//=================================================================================================
int GetEditPointNum()
{
	int		type = m_select->GetSelect();
	if( type == 0 )
		return 0;
	else if( type == 1 )
		return m_gradlinear->GetEditPointNum();
	else if( type == 2 )
		return m_gradradial->GetEditPointNum();
	else if( type == 3 )
		return m_texnearest->GetEditPointNum();
	else if( type == 4 )
		return m_texweight4->GetEditPointNum();
	else if( type == 5 )
		return m_texweight16->GetEditPointNum();
	return 0;
}
//=================================================================================================
fvector2 GetEditPoint
		(
		int		off
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		return m_gradlinear->GetEditPoint( off );
	else if( type == 2 )
		return m_gradradial->GetEditPoint( off );
	else if( type == 3 )
		return m_texnearest->GetEditPoint( off );
	else if( type == 4 )
		return m_texweight4->GetEditPoint( off );
	else if( type == 5 )
		return m_texweight16->GetEditPoint( off );
	return fvector2();
}
//=================================================================================================
void SetEditPoint
		(
		int				off , 
		fvector2		pnt
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		m_gradlinear->SetEditPoint( off , pnt );
	else if( type == 2 )
		m_gradradial->SetEditPoint( off , pnt );
	else if( type == 3 )
		m_texnearest->SetEditPoint( off , pnt );
	else if( type == 4 )
		m_texweight4->SetEditPoint( off , pnt );
	else if( type == 5 )
		m_texweight16->SetEditPoint( off , pnt );
}	
//=================================================================================================
bool SearchEditPoint
		(
		const ivector2&		pnt , 
		int*				pntoff
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		return m_gradlinear->SearchEditPoint( pnt , pntoff );
	else if( type == 2 )
		return m_gradradial->SearchEditPoint( pnt , pntoff );
	else if( type == 3 )
		return m_texnearest->SearchEditPoint( pnt , pntoff );
	else if( type == 4 )
		return m_texweight4->SearchEditPoint( pnt , pntoff );
	else if( type == 5 )
		return m_texweight16->SearchEditPoint( pnt , pntoff );
	return false;
}
//=================================================================================================
void DrawEditHandle
		(
		const faffine&	aff , 
		iSurfaceDest&	surface
		)
{
	int		type = m_select->GetSelect();
	if( type == 1 )
		m_gradlinear->DrawEditHandle( aff , surface );
	else if( type == 2 )
		m_gradradial->DrawEditHandle( aff , surface );
	else if( type == 3 )
		m_texnearest->DrawEditHandle( aff , surface );
	else if( type == 4 )
		m_texweight4->DrawEditHandle( aff , surface );
	else if( type == 5 )
		m_texweight16->DrawEditHandle( aff , surface );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace SourceGenCfgView;		

#pragma pack( pop )			//release align
