/*************************************************************************************************/
/*!
   	@file		TextureCfgView.h
	@author 	Fanzo
 	@date 		2008/6/10
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TextureCfgView" class 
**************************************************************************************************/
class TextureCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioGroupView>			m_select;
	Straightdata<iSurface>				m_texturelist;
	
	rControlMsg							m_msg;
	int									m_id;
	
	const int							m_sh;

// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Horz_RadioAlign );
	int		off , num = m_texturelist.GetDatanum();
	m_select->SetRadioNum( num );
	for( off = 0 ; off < num ; off++ )
	{
		wchar_t		buf[256];
		cb_swprintf( buf , L"tex%d",off+1 );
		m_select->SetString( off , buf );
	}
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_sh ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
// private functions
public:
//=================================================================================================
//!	add texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddTexture
		(
		const wstring&		path , 
		iLoaderImagefile&	loader
		)
{
	instance< FileReader >			file;
	if( false == file->Open( path.c_str() ) )
		return false;
	if( false == loader->Load( ( iFileStreamRead )file ) )
		return false;

	iSurface	surface	= CreateSurface( loader->GetImageSize( 0 ) , rgba_pixelformat , loader->GetImageDPI( 0 ) );
	if( surface->GetDestAvailableArea() == irect( ivector2( 0 , 0 ) , loader->GetImageSize( 0 ) ) )
	{
		int		pitchbyte;
		void	*p = surface->GetDestPixelPtr( &pitchbyte );
		loader->GetImage( 0 , surface->GetDestFormat() , p , pitchbyte );
		m_texturelist[ m_texturelist.Add() ]	= surface;
	}	
	return true;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
TextureCfgView() : 
		m_sh( 15 ) , 
		m_id( 0 )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set colornum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddTexture
		(
		const wstring&	path
		)
{
	// bmp
	{
		instance< LoaderImagefile_bmp >	loader;
		if( true == AddTexture( path , (iLoaderImagefile)loader ) )
			return true;
	}
	// psd
	{
		instance< LoaderImagefile_psd >	loader;
		if( true == AddTexture( path , (iLoaderImagefile)loader ) )
			return true;
	}
	// png
	{
		instance< LoaderImagefile_png >	loader;
		if( true == AddTexture( path , (iLoaderImagefile)loader ) )
			return true;
	}
	return false;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iSurface GetValue()
{
	return m_texturelist[ m_select->GetSelect() ];
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace TextureCfgView;		

#pragma pack( pop )			//release align
