/*************************************************************************************************/
/*!
   	@file		iCoordLayer.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "ICoordLayer" interface 
***************************************************************************************************/
cb_guid_define( ICoordLayer_IID , 0x7689E4D5 , 0xB12E41fc , 0x9493055D , 0x8AAB75F9 );
class ICoordLayer;
typedef icubic::iface_object< ICoordLayer , ICoordLayer_IID >		iCoordLayer;
typedef icubic::iface_reference< ICoordLayer , ICoordLayer_IID >	rCoordLayer;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ICoordLayer
{
public:
//=================================================================================================
//!	copy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call CopyItem() = 0;
//=================================================================================================
//!	copy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call Copy() = 0;
//=================================================================================================
//!	copy
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call Copy
		(
		iCoordLayer&	end , 
		iCoordLayer*	endpos
		) = 0;
//=================================================================================================
//!	get root layer
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call GetRoot() = 0;
//=================================================================================================
//!	set parent layer
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetParent
		(
		iCoordLayer&	parent
		) = 0;
//=================================================================================================
//!	get parent layer
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call GetParent() = 0;
//=================================================================================================
//!	add child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call AddChild
		(
		iCoordLayer&	layer , 
		int				insertpos	= -1
		) = 0;
//=================================================================================================
//!	add child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call AddChild
		(
		iCoordLayer&	layer , 
		iCoordLayer&	end_layer , 
		iCoordLayer*	end_pos		= 0 , 
		int				insertpos	= -1
		) = 0;
//=================================================================================================
//!	delete child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call RemoveChild
		(
		iCoordLayer&	child
		) = 0;
//=================================================================================================
//!	delete 
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Remove() = 0;
//=================================================================================================
//!	get childnum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
int cb_call GetChildnum() = 0;
//=================================================================================================
//!	get child
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iCoordLayer cb_call GetChild
		(
		int		off
		) = 0;
//=================================================================================================
//!	get coord_l
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call GetCoord_l
		(
		Coord_l*		coord
		) = 0;
//=================================================================================================
//!	get coord_ld
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call GetCoord_ld
		(
		Coord_ld*		coord ,
		fsize*			local ,  
		frect*			view
		) = 0;
//=================================================================================================
//!	logical to device transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call LtoD() = 0;
//=================================================================================================
//!	convert coord to coord
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call CtoC
		(
		value_ipl::Unit		dest_unit , 
		value_ipl::Unit		src_unit , 
		iCoordLayer&		src_layer
		) = 0;
};
/**************************************************************************************************
 "ISubCoordLayer" interface 
***************************************************************************************************/
cb_guid_define( ISubCoordLayer_IID , 0x504ED4FE , 0x56AD42ed , 0xA721FA02 , 0xCDA439D7 );
class ISubCoordLayer;
typedef icubic::iface_object< ISubCoordLayer , ISubCoordLayer_IID >		iSubCoordLayer;
typedef icubic::iface_reference< ISubCoordLayer , ISubCoordLayer_IID >	rSubCoordLayer;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISubCoordLayer : public ICoordLayer
{
public:
	point_iplr		m_org;
	unit_ip			m_unit;
	float			m_rotate;
};
/**************************************************************************************************
 "IViewCoordLayer" interface 
***************************************************************************************************/
cb_guid_define( IViewCoordLayer_IID , 0xB5EA176D , 0xD6974117 , 0xA1D6EECA , 0xE1AD28D5 );
class IViewCoordLayer;
typedef icubic::iface_object< IViewCoordLayer , IViewCoordLayer_IID >		iViewCoordLayer;
typedef icubic::iface_reference< IViewCoordLayer , IViewCoordLayer_IID >	rViewCoordLayer;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IViewCoordLayer : public ICoordLayer
{
public:
	enum AspectRatio
	{
		Adjust , 
		AspectMin , 
		AspectMax
	};
	enum Align
	{
		MinAlign , 
		MidAlign , 
		MaxAlign , 
	};
	rect_iplr		m_dest_view;
	size_ip			m_view;
	DPI				m_dpi;
	unit_ip			m_unit;
	AspectRatio		m_aspect;
	Align			m_horz;
	Align			m_vert;
};
/**************************************************************************************************
 "IDeviceCoordLayer" interface 
***************************************************************************************************/
cb_guid_define( IDeviceCoordLayer_IID , 0xA1479757 , 0x60B5459b , 0xB25CD18E , 0x0F158355 );
class IDeviceCoordLayer;
typedef icubic::iface_object< IDeviceCoordLayer , IDeviceCoordLayer_IID >		iDeviceCoordLayer;
typedef icubic::iface_reference< IDeviceCoordLayer , IDeviceCoordLayer_IID >	rDeviceCoordLayer;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IDeviceCoordLayer : public ICoordLayer
{
public:
	DPI		m_dpi;
	frect	m_view;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
