/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.SimpleAuthenticationBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthenticationPlugin
implements BrokerPlugin {
    private Map<String, String> userPasswords;
    private Map<String, Set<GroupPrincipal>> userGroups;

    public SimpleAuthenticationPlugin() {
    }

    public SimpleAuthenticationPlugin(List users) {
        this.setUsers(users);
    }

    @Override
    public Broker installPlugin(Broker broker) {
        return new SimpleAuthenticationBroker(broker, this.userPasswords, this.userGroups);
    }

    public Map<String, Set<GroupPrincipal>> getUserGroups() {
        return this.userGroups;
    }

    public void setUsers(List users) {
        this.userPasswords = new HashMap<String, String>();
        this.userGroups = new HashMap<String, Set<GroupPrincipal>>();
        for (AuthenticationUser user : users) {
            this.userPasswords.put(user.getUsername(), user.getPassword());
            HashSet<GroupPrincipal> groups = new HashSet<GroupPrincipal>();
            StringTokenizer iter = new StringTokenizer(user.getGroups(), ",");
            while (iter.hasMoreTokens()) {
                String name = iter.nextToken().trim();
                groups.add(new GroupPrincipal(name));
            }
            this.userGroups.put(user.getUsername(), groups);
        }
    }

    public void setUserGroups(Map<String, Set<GroupPrincipal>> userGroups) {
        this.userGroups = userGroups;
    }

    public Map<String, String> getUserPasswords() {
        return this.userPasswords;
    }

    public void setUserPasswords(Map<String, String> userPasswords) {
        this.userPasswords = userPasswords;
    }
}

