/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.compiere.apps.wf.MultilineLabelWidget;
import org.compiere.model.MImage;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

public class WFNodeWidget
extends Widget {
    public static final int NODE_WIDTH = 150;
    public static final int NODE_HEIGHT = 100;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder((int)4);
    private int row = 0;
    private int column = 0;
    private MWFNode model;

    public WFNodeWidget(Scene scene, MWFNode node) {
        super(scene);
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setOpaque(true);
        this.setCheckClipping(true);
        this.setPreferredSize(new Dimension(150, 100));
        ImageWidget imageWidget = null;
        int imageId = node.getAD_Image_ID();
        if (imageId > 0) {
            MImage mImage = MImage.get((Properties)Env.getCtx(), (int)imageId);
            BufferedImage image = null;
            byte[] imageData = mImage.getBinaryData();
            if (imageData != null && imageData.length > 0) {
                try {
                    image = ImageIO.read(new ByteArrayInputStream(imageData));
                }
                catch (IOException iOException) {}
            } else {
                String url = mImage.getImageURL();
                if (url != null && url.trim().length() > 0) {
                    try {
                        image = ImageIO.read(new URL(url));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (image != null) {
                imageWidget = new ImageWidget(scene, (Image)image);
                imageWidget.setToolTipText(node.getName());
                this.addChild((Widget)imageWidget);
            }
        } else {
            String titleText;
            this.setBorder(BorderFactory.createLineBorder());
            Widget titleWidget = new Widget(scene);
            titleWidget.setLayout(LayoutFactory.createHorizontalFlowLayout());
            titleWidget.setBorder(EMPTY_BORDER);
            ImageWidget titleIcon = new ImageWidget(scene);
            String action = node.getAction();
            int index = MTreeNode.getImageIndex((String)action);
            ImageIcon icon = (ImageIcon)MTreeNode.getIcon((int)index);
            if (icon != null) {
                titleIcon.setImage(icon.getImage());
                titleIcon.setToolTipText(this.getActionType(node));
                titleWidget.addChild((Widget)titleIcon);
            }
            if ((titleText = node.getName()).length() > 20) {
                titleText = String.valueOf(titleText.substring(0, 20)) + "...";
            }
            LabelWidget titleTextWidget = new LabelWidget(scene, titleText);
            titleTextWidget.setFont(scene.getDefaultFont().deriveFont(1));
            if (titleText.length() > 20) {
                titleTextWidget.setToolTipText(node.getName());
            }
            titleWidget.addChild((Widget)titleTextWidget);
            this.addChild(titleWidget);
            this.addChild((Widget)new SeparatorWidget(scene, SeparatorWidget.Orientation.HORIZONTAL));
            String description = node.getDescription(true);
            if (description != null && description.length() > 0) {
                MultilineLabelWidget label = new MultilineLabelWidget(scene, description);
                label.setPreferredSize(new Dimension(130, 80));
                this.addChild((Widget)label);
            }
        }
        this.model = node;
    }

    public String getActionType(MWFNode node) {
        String action = node.getAction();
        if ("P".equals(action)) {
            return "Process";
        }
        if ("D".equals(action)) {
            return "Document Action: " + node.getDocAction();
        }
        if ("R".equals(action)) {
            return "Report";
        }
        if ("T".equals(action)) {
            return "Task";
        }
        if ("V".equals(action)) {
            return "Set Variable";
        }
        if ("F".equals(action)) {
            return "Workflow";
        }
        if ("C".equals(action)) {
            return "User Choice";
        }
        if ("X".equals(action)) {
            return "Form";
        }
        if ("W".equals(action)) {
            return "Window";
        }
        if ("Z".equals(action)) {
            return "Sleep:WaitTime=" + node.getWaitTime();
        }
        return "";
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public MWFNode getModel() {
        return this.model;
    }
}

